/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.loganalytics.models.CapacityReservationLevel;
import com.azure.resourcemanager.loganalytics.models.WorkspaceSkuNameEnum;
import java.io.IOException;

public final class WorkspaceSku
implements JsonSerializable<WorkspaceSku> {
    private WorkspaceSkuNameEnum name;
    private CapacityReservationLevel capacityReservationLevel;
    private String lastSkuUpdate;
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceSku.class);

    public WorkspaceSkuNameEnum name() {
        return this.name;
    }

    public WorkspaceSku withName(WorkspaceSkuNameEnum name) {
        this.name = name;
        return this;
    }

    public CapacityReservationLevel capacityReservationLevel() {
        return this.capacityReservationLevel;
    }

    public WorkspaceSku withCapacityReservationLevel(CapacityReservationLevel capacityReservationLevel) {
        this.capacityReservationLevel = capacityReservationLevel;
        return this;
    }

    public String lastSkuUpdate() {
        return this.lastSkuUpdate;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model WorkspaceSku"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeNumberField("capacityReservationLevel", this.capacityReservationLevel == null ? null : Integer.valueOf(this.capacityReservationLevel.toInt()));
        return jsonWriter.writeEndObject();
    }

    public static WorkspaceSku fromJson(JsonReader jsonReader) throws IOException {
        return (WorkspaceSku)jsonReader.readObject(reader -> {
            WorkspaceSku deserializedWorkspaceSku = new WorkspaceSku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedWorkspaceSku.name = WorkspaceSkuNameEnum.fromString(reader.getString());
                    continue;
                }
                if ("capacityReservationLevel".equals(fieldName)) {
                    deserializedWorkspaceSku.capacityReservationLevel = CapacityReservationLevel.fromInt(reader.getInt());
                    continue;
                }
                if ("lastSkuUpdate".equals(fieldName)) {
                    deserializedWorkspaceSku.lastSkuUpdate = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkspaceSku;
        });
    }
}

