/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.monitor.MonitorManager;
import com.azure.resourcemanager.monitor.fluent.MetricDefinitionsClient;
import com.azure.resourcemanager.monitor.fluent.MonitorClient;
import com.azure.resourcemanager.monitor.fluent.models.MetricDefinitionInner;
import com.azure.resourcemanager.monitor.implementation.MetricDefinitionImpl;
import com.azure.resourcemanager.monitor.models.MetricDefinition;
import com.azure.resourcemanager.monitor.models.MetricDefinitions;

public class MetricDefinitionsImpl
implements MetricDefinitions {
    private final MonitorManager myManager;

    public MetricDefinitionsImpl(MonitorManager monitorManager) {
        this.myManager = monitorManager;
    }

    public MonitorManager manager() {
        return this.myManager;
    }

    public MetricDefinitionsClient inner() {
        return ((MonitorClient)this.myManager.serviceClient()).getMetricDefinitions();
    }

    @Override
    public PagedIterable<MetricDefinition> listByResource(String resourceId) {
        return this.inner().list(resourceId).mapPage(inner -> new MetricDefinitionImpl((MetricDefinitionInner)inner, this.myManager));
    }

    @Override
    public PagedFlux<MetricDefinition> listByResourceAsync(String resourceId) {
        return this.inner().listAsync(resourceId).mapPage(inner -> new MetricDefinitionImpl((MetricDefinitionInner)inner, this.myManager));
    }
}

