/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.RuleAction;
import com.azure.resourcemanager.monitor.models.RuleCondition;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class AlertRuleResourcePatch {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AlertRuleResourcePatch.class);
    @JsonProperty(value="tags")
    private Map<String, String> tags;
    @JsonProperty(value="properties.name")
    private String name;
    @JsonProperty(value="properties.description")
    private String description;
    @JsonProperty(value="properties.isEnabled")
    private Boolean isEnabled;
    @JsonProperty(value="properties.condition")
    private RuleCondition condition;
    @JsonProperty(value="properties.actions")
    private List<RuleAction> actions;
    @JsonProperty(value="properties.lastUpdatedTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastUpdatedTime;

    public Map<String, String> tags() {
        return this.tags;
    }

    public AlertRuleResourcePatch withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String name() {
        return this.name;
    }

    public AlertRuleResourcePatch withName(String name) {
        this.name = name;
        return this;
    }

    public String description() {
        return this.description;
    }

    public AlertRuleResourcePatch withDescription(String description) {
        this.description = description;
        return this;
    }

    public Boolean isEnabled() {
        return this.isEnabled;
    }

    public AlertRuleResourcePatch withIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    public RuleCondition condition() {
        return this.condition;
    }

    public AlertRuleResourcePatch withCondition(RuleCondition condition) {
        this.condition = condition;
        return this;
    }

    public List<RuleAction> actions() {
        return this.actions;
    }

    public AlertRuleResourcePatch withActions(List<RuleAction> actions) {
        this.actions = actions;
        return this;
    }

    public OffsetDateTime lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public void validate() {
        if (this.condition() != null) {
            this.condition().validate();
        }
        if (this.actions() != null) {
            this.actions().forEach(e -> e.validate());
        }
    }
}

