/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.AggregationType;
import com.azure.resourcemanager.monitor.models.DynamicMetricCriteria;
import com.azure.resourcemanager.monitor.models.MetricCriteria;
import com.azure.resourcemanager.monitor.models.MetricDimension;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="criterionType", defaultImpl=MultiMetricCriteria.class)
@JsonTypeName(value="MultiMetricCriteria")
@JsonSubTypes(value={@JsonSubTypes.Type(name="StaticThresholdCriterion", value=MetricCriteria.class), @JsonSubTypes.Type(name="DynamicThresholdCriterion", value=DynamicMetricCriteria.class)})
public class MultiMetricCriteria {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(MultiMetricCriteria.class);
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="metricName", required=true)
    private String metricName;
    @JsonProperty(value="metricNamespace")
    private String metricNamespace;
    @JsonProperty(value="timeAggregation", required=true)
    private AggregationType timeAggregation;
    @JsonProperty(value="dimensions")
    private List<MetricDimension> dimensions;
    @JsonProperty(value="skipMetricValidation")
    private Boolean skipMetricValidation;
    @JsonIgnore
    private Map<String, Object> additionalProperties;

    public String name() {
        return this.name;
    }

    public MultiMetricCriteria withName(String name) {
        this.name = name;
        return this;
    }

    public String metricName() {
        return this.metricName;
    }

    public MultiMetricCriteria withMetricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    public String metricNamespace() {
        return this.metricNamespace;
    }

    public MultiMetricCriteria withMetricNamespace(String metricNamespace) {
        this.metricNamespace = metricNamespace;
        return this;
    }

    public AggregationType timeAggregation() {
        return this.timeAggregation;
    }

    public MultiMetricCriteria withTimeAggregation(AggregationType timeAggregation) {
        this.timeAggregation = timeAggregation;
        return this;
    }

    public List<MetricDimension> dimensions() {
        return this.dimensions;
    }

    public MultiMetricCriteria withDimensions(List<MetricDimension> dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public Boolean skipMetricValidation() {
        return this.skipMetricValidation;
    }

    public MultiMetricCriteria withSkipMetricValidation(Boolean skipMetricValidation) {
        this.skipMetricValidation = skipMetricValidation;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public MultiMetricCriteria withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
    }

    public void validate() {
        if (this.name() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model MultiMetricCriteria"));
        }
        if (this.metricName() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property metricName in model MultiMetricCriteria"));
        }
        if (this.timeAggregation() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property timeAggregation in model MultiMetricCriteria"));
        }
        if (this.dimensions() != null) {
            this.dimensions().forEach(e -> e.validate());
        }
    }
}

