// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.fluent.ActivityLogAlertsClient;
import com.azure.resourcemanager.monitor.fluent.models.ActivityLogAlertResourceInner;
import com.azure.resourcemanager.monitor.models.ActivityLogAlertList;
import com.azure.resourcemanager.monitor.models.ActivityLogAlertPatchBody;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in ActivityLogAlertsClient. */
public final class ActivityLogAlertsClientImpl
    implements InnerSupportsGet<ActivityLogAlertResourceInner>,
        InnerSupportsListing<ActivityLogAlertResourceInner>,
        InnerSupportsDelete<Void>,
        ActivityLogAlertsClient {
    private final ClientLogger logger = new ClientLogger(ActivityLogAlertsClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final ActivityLogAlertsService service;

    /** The service client containing this operation class. */
    private final MonitorClientImpl client;

    /**
     * Initializes an instance of ActivityLogAlertsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    ActivityLogAlertsClientImpl(MonitorClientImpl client) {
        this.service =
            RestProxy.create(ActivityLogAlertsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for MonitorClientActivityLogAlerts to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "MonitorClientActivit")
    private interface ActivityLogAlertsService {
        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights"
                + "/activityLogAlerts/{activityLogAlertName}")
        @ExpectedResponses({200, 201})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ActivityLogAlertResourceInner>> createOrUpdate(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("activityLogAlertName") String activityLogAlertName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ActivityLogAlertResourceInner activityLogAlert,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights"
                + "/activityLogAlerts/{activityLogAlertName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ActivityLogAlertResourceInner>> getByResourceGroup(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("activityLogAlertName") String activityLogAlertName,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights"
                + "/activityLogAlerts/{activityLogAlertName}")
        @ExpectedResponses({200, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> delete(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("activityLogAlertName") String activityLogAlertName,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Patch(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights"
                + "/activityLogAlerts/{activityLogAlertName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ActivityLogAlertResourceInner>> update(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("activityLogAlertName") String activityLogAlertName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ActivityLogAlertPatchBody activityLogAlertPatch,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("/subscriptions/{subscriptionId}/providers/microsoft.insights/activityLogAlerts")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ActivityLogAlertList>> list(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights"
                + "/activityLogAlerts")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ActivityLogAlertList>> listByResourceGroup(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @QueryParam("api-version") String apiVersion,
            Context context);
    }

    /**
     * Create a new activity log alert or update an existing one.
     *
     * @param resourceGroupName The name of the resource group.
     * @param activityLogAlertName The name of the activity log alert.
     * @param activityLogAlert An activity log alert resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an activity log alert resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ActivityLogAlertResourceInner>> createOrUpdateWithResponseAsync(
        String resourceGroupName, String activityLogAlertName, ActivityLogAlertResourceInner activityLogAlert) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (activityLogAlertName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter activityLogAlertName is required and cannot be null."));
        }
        if (activityLogAlert == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter activityLogAlert is required and cannot be null."));
        } else {
            activityLogAlert.validate();
        }
        final String apiVersion = "2017-04-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createOrUpdate(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            activityLogAlertName,
                            apiVersion,
                            activityLogAlert,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Create a new activity log alert or update an existing one.
     *
     * @param resourceGroupName The name of the resource group.
     * @param activityLogAlertName The name of the activity log alert.
     * @param activityLogAlert An activity log alert resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an activity log alert resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ActivityLogAlertResourceInner>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String activityLogAlertName,
        ActivityLogAlertResourceInner activityLogAlert,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (activityLogAlertName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter activityLogAlertName is required and cannot be null."));
        }
        if (activityLogAlert == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter activityLogAlert is required and cannot be null."));
        } else {
            activityLogAlert.validate();
        }
        final String apiVersion = "2017-04-01";
        context = this.client.mergeContext(context);
        return service
            .createOrUpdate(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                activityLogAlertName,
                apiVersion,
                activityLogAlert,
                context);
    }

    /**
     * Create a new activity log alert or update an existing one.
     *
     * @param resourceGroupName The name of the resource group.
     * @param activityLogAlertName The name of the activity log alert.
     * @param activityLogAlert An activity log alert resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an activity log alert resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ActivityLogAlertResourceInner> createOrUpdateAsync(
        String resourceGroupName, String activityLogAlertName, ActivityLogAlertResourceInner activityLogAlert) {
        return createOrUpdateWithResponseAsync(resourceGroupName, activityLogAlertName, activityLogAlert)
            .flatMap(
                (Response<ActivityLogAlertResourceInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Create a new activity log alert or update an existing one.
     *
     * @param resourceGroupName The name of the resource group.
     * @param activityLogAlertName The name of the activity log alert.
     * @param activityLogAlert An activity log alert resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an activity log alert resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ActivityLogAlertResourceInner createOrUpdate(
        String resourceGroupName, String activityLogAlertName, ActivityLogAlertResourceInner activityLogAlert) {
        return createOrUpdateAsync(resourceGroupName, activityLogAlertName, activityLogAlert).block();
    }

    /**
     * Create a new activity log alert or update an existing one.
     *
     * @param resourceGroupName The name of the resource group.
     * @param activityLogAlertName The name of the activity log alert.
     * @param activityLogAlert An activity log alert resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an activity log alert resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ActivityLogAlertResourceInner> createOrUpdateWithResponse(
        String resourceGroupName,
        String activityLogAlertName,
        ActivityLogAlertResourceInner activityLogAlert,
        Context context) {
        return createOrUpdateWithResponseAsync(resourceGroupName, activityLogAlertName, activityLogAlert, context)
            .block();
    }

    /**
     * Get an activity log alert.
     *
     * @param resourceGroupName The name of the resource group.
     * @param activityLogAlertName The name of the activity log alert.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an activity log alert.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ActivityLogAlertResourceInner>> getByResourceGroupWithResponseAsync(
        String resourceGroupName, String activityLogAlertName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (activityLogAlertName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter activityLogAlertName is required and cannot be null."));
        }
        final String apiVersion = "2017-04-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getByResourceGroup(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            activityLogAlertName,
                            apiVersion,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get an activity log alert.
     *
     * @param resourceGroupName The name of the resource group.
     * @param activityLogAlertName The name of the activity log alert.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an activity log alert.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ActivityLogAlertResourceInner>> getByResourceGroupWithResponseAsync(
        String resourceGroupName, String activityLogAlertName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (activityLogAlertName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter activityLogAlertName is required and cannot be null."));
        }
        final String apiVersion = "2017-04-01";
        context = this.client.mergeContext(context);
        return service
            .getByResourceGroup(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                activityLogAlertName,
                apiVersion,
                context);
    }

    /**
     * Get an activity log alert.
     *
     * @param resourceGroupName The name of the resource group.
     * @param activityLogAlertName The name of the activity log alert.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an activity log alert.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ActivityLogAlertResourceInner> getByResourceGroupAsync(
        String resourceGroupName, String activityLogAlertName) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, activityLogAlertName)
            .flatMap(
                (Response<ActivityLogAlertResourceInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get an activity log alert.
     *
     * @param resourceGroupName The name of the resource group.
     * @param activityLogAlertName The name of the activity log alert.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an activity log alert.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ActivityLogAlertResourceInner getByResourceGroup(String resourceGroupName, String activityLogAlertName) {
        return getByResourceGroupAsync(resourceGroupName, activityLogAlertName).block();
    }

    /**
     * Get an activity log alert.
     *
     * @param resourceGroupName The name of the resource group.
     * @param activityLogAlertName The name of the activity log alert.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an activity log alert.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ActivityLogAlertResourceInner> getByResourceGroupWithResponse(
        String resourceGroupName, String activityLogAlertName, Context context) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, activityLogAlertName, context).block();
    }

    /**
     * Delete an activity log alert.
     *
     * @param resourceGroupName The name of the resource group.
     * @param activityLogAlertName The name of the activity log alert.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String activityLogAlertName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (activityLogAlertName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter activityLogAlertName is required and cannot be null."));
        }
        final String apiVersion = "2017-04-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            activityLogAlertName,
                            apiVersion,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Delete an activity log alert.
     *
     * @param resourceGroupName The name of the resource group.
     * @param activityLogAlertName The name of the activity log alert.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(
        String resourceGroupName, String activityLogAlertName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (activityLogAlertName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter activityLogAlertName is required and cannot be null."));
        }
        final String apiVersion = "2017-04-01";
        context = this.client.mergeContext(context);
        return service
            .delete(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                activityLogAlertName,
                apiVersion,
                context);
    }

    /**
     * Delete an activity log alert.
     *
     * @param resourceGroupName The name of the resource group.
     * @param activityLogAlertName The name of the activity log alert.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String activityLogAlertName) {
        return deleteWithResponseAsync(resourceGroupName, activityLogAlertName)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete an activity log alert.
     *
     * @param resourceGroupName The name of the resource group.
     * @param activityLogAlertName The name of the activity log alert.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String activityLogAlertName) {
        deleteAsync(resourceGroupName, activityLogAlertName).block();
    }

    /**
     * Delete an activity log alert.
     *
     * @param resourceGroupName The name of the resource group.
     * @param activityLogAlertName The name of the activity log alert.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String activityLogAlertName, Context context) {
        return deleteWithResponseAsync(resourceGroupName, activityLogAlertName, context).block();
    }

    /**
     * Updates an existing ActivityLogAlertResource's tags. To update other fields use the CreateOrUpdate method.
     *
     * @param resourceGroupName The name of the resource group.
     * @param activityLogAlertName The name of the activity log alert.
     * @param activityLogAlertPatch An activity log alert object for the body of patch operations.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an activity log alert resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ActivityLogAlertResourceInner>> updateWithResponseAsync(
        String resourceGroupName, String activityLogAlertName, ActivityLogAlertPatchBody activityLogAlertPatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (activityLogAlertName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter activityLogAlertName is required and cannot be null."));
        }
        if (activityLogAlertPatch == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter activityLogAlertPatch is required and cannot be null."));
        } else {
            activityLogAlertPatch.validate();
        }
        final String apiVersion = "2017-04-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .update(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            activityLogAlertName,
                            apiVersion,
                            activityLogAlertPatch,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Updates an existing ActivityLogAlertResource's tags. To update other fields use the CreateOrUpdate method.
     *
     * @param resourceGroupName The name of the resource group.
     * @param activityLogAlertName The name of the activity log alert.
     * @param activityLogAlertPatch An activity log alert object for the body of patch operations.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an activity log alert resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ActivityLogAlertResourceInner>> updateWithResponseAsync(
        String resourceGroupName,
        String activityLogAlertName,
        ActivityLogAlertPatchBody activityLogAlertPatch,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (activityLogAlertName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter activityLogAlertName is required and cannot be null."));
        }
        if (activityLogAlertPatch == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter activityLogAlertPatch is required and cannot be null."));
        } else {
            activityLogAlertPatch.validate();
        }
        final String apiVersion = "2017-04-01";
        context = this.client.mergeContext(context);
        return service
            .update(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                activityLogAlertName,
                apiVersion,
                activityLogAlertPatch,
                context);
    }

    /**
     * Updates an existing ActivityLogAlertResource's tags. To update other fields use the CreateOrUpdate method.
     *
     * @param resourceGroupName The name of the resource group.
     * @param activityLogAlertName The name of the activity log alert.
     * @param activityLogAlertPatch An activity log alert object for the body of patch operations.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an activity log alert resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ActivityLogAlertResourceInner> updateAsync(
        String resourceGroupName, String activityLogAlertName, ActivityLogAlertPatchBody activityLogAlertPatch) {
        return updateWithResponseAsync(resourceGroupName, activityLogAlertName, activityLogAlertPatch)
            .flatMap(
                (Response<ActivityLogAlertResourceInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Updates an existing ActivityLogAlertResource's tags. To update other fields use the CreateOrUpdate method.
     *
     * @param resourceGroupName The name of the resource group.
     * @param activityLogAlertName The name of the activity log alert.
     * @param activityLogAlertPatch An activity log alert object for the body of patch operations.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an activity log alert resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ActivityLogAlertResourceInner update(
        String resourceGroupName, String activityLogAlertName, ActivityLogAlertPatchBody activityLogAlertPatch) {
        return updateAsync(resourceGroupName, activityLogAlertName, activityLogAlertPatch).block();
    }

    /**
     * Updates an existing ActivityLogAlertResource's tags. To update other fields use the CreateOrUpdate method.
     *
     * @param resourceGroupName The name of the resource group.
     * @param activityLogAlertName The name of the activity log alert.
     * @param activityLogAlertPatch An activity log alert object for the body of patch operations.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an activity log alert resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ActivityLogAlertResourceInner> updateWithResponse(
        String resourceGroupName,
        String activityLogAlertName,
        ActivityLogAlertPatchBody activityLogAlertPatch,
        Context context) {
        return updateWithResponseAsync(resourceGroupName, activityLogAlertName, activityLogAlertPatch, context).block();
    }

    /**
     * Get a list of all activity log alerts in a subscription.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all activity log alerts in a subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ActivityLogAlertResourceInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2017-04-01";
        return FluxUtil
            .withContext(
                context ->
                    service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), apiVersion, context))
            .<PagedResponse<ActivityLogAlertResourceInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get a list of all activity log alerts in a subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all activity log alerts in a subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ActivityLogAlertResourceInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2017-04-01";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), this.client.getSubscriptionId(), apiVersion, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null));
    }

    /**
     * Get a list of all activity log alerts in a subscription.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all activity log alerts in a subscription.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ActivityLogAlertResourceInner> listAsync() {
        return new PagedFlux<>(() -> listSinglePageAsync());
    }

    /**
     * Get a list of all activity log alerts in a subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all activity log alerts in a subscription.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ActivityLogAlertResourceInner> listAsync(Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(context));
    }

    /**
     * Get a list of all activity log alerts in a subscription.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all activity log alerts in a subscription.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ActivityLogAlertResourceInner> list() {
        return new PagedIterable<>(listAsync());
    }

    /**
     * Get a list of all activity log alerts in a subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all activity log alerts in a subscription.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ActivityLogAlertResourceInner> list(Context context) {
        return new PagedIterable<>(listAsync(context));
    }

    /**
     * Get a list of all activity log alerts in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all activity log alerts in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ActivityLogAlertResourceInner>> listByResourceGroupSinglePageAsync(
        String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        final String apiVersion = "2017-04-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listByResourceGroup(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            apiVersion,
                            context))
            .<PagedResponse<ActivityLogAlertResourceInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get a list of all activity log alerts in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all activity log alerts in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ActivityLogAlertResourceInner>> listByResourceGroupSinglePageAsync(
        String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        final String apiVersion = "2017-04-01";
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroup(
                this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, apiVersion, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null));
    }

    /**
     * Get a list of all activity log alerts in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all activity log alerts in a resource group.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ActivityLogAlertResourceInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName));
    }

    /**
     * Get a list of all activity log alerts in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all activity log alerts in a resource group.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ActivityLogAlertResourceInner> listByResourceGroupAsync(
        String resourceGroupName, Context context) {
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName, context));
    }

    /**
     * Get a list of all activity log alerts in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all activity log alerts in a resource group.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ActivityLogAlertResourceInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName));
    }

    /**
     * Get a list of all activity log alerts in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all activity log alerts in a resource group.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ActivityLogAlertResourceInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, context));
    }
}
