// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Represents a baseline metadata value. */
@Fluent
public final class BaselineMetadata {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(BaselineMetadata.class);

    /*
     * Name of the baseline metadata.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /*
     * Value of the baseline metadata.
     */
    @JsonProperty(value = "value", required = true)
    private String value;

    /**
     * Get the name property: Name of the baseline metadata.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the baseline metadata.
     *
     * @param name the name value to set.
     * @return the BaselineMetadata object itself.
     */
    public BaselineMetadata withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the value property: Value of the baseline metadata.
     *
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: Value of the baseline metadata.
     *
     * @param value the value value to set.
     * @return the BaselineMetadata object itself.
     */
    public BaselineMetadata withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property name in model BaselineMetadata"));
        }
        if (value() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property value in model BaselineMetadata"));
        }
    }
}
