/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.monitor.fluent.EventCategoriesClient;
import com.azure.resourcemanager.monitor.fluent.models.LocalizableStringInner;
import com.azure.resourcemanager.monitor.implementation.MonitorClientImpl;
import com.azure.resourcemanager.monitor.models.EventCategoryCollection;
import reactor.core.publisher.Mono;

public final class EventCategoriesClientImpl
implements EventCategoriesClient {
    private final ClientLogger logger = new ClientLogger(EventCategoriesClientImpl.class);
    private final EventCategoriesService service;
    private final MonitorClientImpl client;

    EventCategoriesClientImpl(MonitorClientImpl client) {
        this.service = (EventCategoriesService)RestProxy.create(EventCategoriesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<LocalizableStringInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String apiVersion = "2015-04-01";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2015-04-01", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventCategoryCollection)res.getValue()).value(), null, null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<LocalizableStringInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String apiVersion = "2015-04-01";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2015-04-01", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventCategoryCollection)res.getValue()).value(), null, null));
    }

    @Override
    public PagedFlux<LocalizableStringInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync());
    }

    private PagedFlux<LocalizableStringInner> listAsync(Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(context));
    }

    @Override
    public PagedIterable<LocalizableStringInner> list() {
        return new PagedIterable(this.listAsync());
    }

    @Override
    public PagedIterable<LocalizableStringInner> list(Context context) {
        return new PagedIterable(this.listAsync(context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MonitorClientEventCa")
    private static interface EventCategoriesService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/providers/microsoft.insights/eventcategories")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventCategoryCollection>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, Context var3);
    }
}

