/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.monitor.fluent.LogProfilesClient;
import com.azure.resourcemanager.monitor.fluent.models.LogProfileResourceInner;
import com.azure.resourcemanager.monitor.implementation.MonitorClientImpl;
import com.azure.resourcemanager.monitor.models.LogProfileCollection;
import com.azure.resourcemanager.monitor.models.LogProfileResourcePatch;
import reactor.core.publisher.Mono;

public final class LogProfilesClientImpl
implements LogProfilesClient {
    private final ClientLogger logger = new ClientLogger(LogProfilesClientImpl.class);
    private final LogProfilesService service;
    private final MonitorClientImpl client;

    LogProfilesClientImpl(MonitorClientImpl client) {
        this.service = (LogProfilesService)RestProxy.create(LogProfilesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<Void>> deleteWithResponseAsync(String logProfileName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (logProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter logProfileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2016-03-01";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), logProfileName, "2016-03-01", this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteWithResponseAsync(String logProfileName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (logProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter logProfileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2016-03-01";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), logProfileName, "2016-03-01", this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<Void> deleteAsync(String logProfileName) {
        return this.deleteWithResponseAsync(logProfileName).flatMap(res -> Mono.empty());
    }

    @Override
    public void delete(String logProfileName) {
        this.deleteAsync(logProfileName).block();
    }

    @Override
    public Response<Void> deleteWithResponse(String logProfileName, Context context) {
        return (Response)this.deleteWithResponseAsync(logProfileName, context).block();
    }

    @Override
    public Mono<Response<LogProfileResourceInner>> getWithResponseAsync(String logProfileName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (logProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter logProfileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2016-03-01";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), logProfileName, "2016-03-01", this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<LogProfileResourceInner>> getWithResponseAsync(String logProfileName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (logProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter logProfileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2016-03-01";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), logProfileName, "2016-03-01", this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<LogProfileResourceInner> getAsync(String logProfileName) {
        return this.getWithResponseAsync(logProfileName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((LogProfileResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public LogProfileResourceInner get(String logProfileName) {
        return (LogProfileResourceInner)((Object)this.getAsync(logProfileName).block());
    }

    @Override
    public Response<LogProfileResourceInner> getWithResponse(String logProfileName, Context context) {
        return (Response)this.getWithResponseAsync(logProfileName, context).block();
    }

    @Override
    public Mono<Response<LogProfileResourceInner>> createOrUpdateWithResponseAsync(String logProfileName, LogProfileResourceInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (logProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter logProfileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2016-03-01";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), logProfileName, "2016-03-01", this.client.getSubscriptionId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<LogProfileResourceInner>> createOrUpdateWithResponseAsync(String logProfileName, LogProfileResourceInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (logProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter logProfileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2016-03-01";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), logProfileName, "2016-03-01", this.client.getSubscriptionId(), parameters, context);
    }

    @Override
    public Mono<LogProfileResourceInner> createOrUpdateAsync(String logProfileName, LogProfileResourceInner parameters) {
        return this.createOrUpdateWithResponseAsync(logProfileName, parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((LogProfileResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public LogProfileResourceInner createOrUpdate(String logProfileName, LogProfileResourceInner parameters) {
        return (LogProfileResourceInner)((Object)this.createOrUpdateAsync(logProfileName, parameters).block());
    }

    @Override
    public Response<LogProfileResourceInner> createOrUpdateWithResponse(String logProfileName, LogProfileResourceInner parameters, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(logProfileName, parameters, context).block();
    }

    @Override
    public Mono<Response<LogProfileResourceInner>> updateWithResponseAsync(String logProfileName, LogProfileResourcePatch logProfilesResource) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (logProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter logProfileName is required and cannot be null."));
        }
        if (logProfilesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter logProfilesResource is required and cannot be null."));
        }
        logProfilesResource.validate();
        String apiVersion = "2016-03-01";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), logProfileName, "2016-03-01", logProfilesResource, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<LogProfileResourceInner>> updateWithResponseAsync(String logProfileName, LogProfileResourcePatch logProfilesResource, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (logProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter logProfileName is required and cannot be null."));
        }
        if (logProfilesResource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter logProfilesResource is required and cannot be null."));
        }
        logProfilesResource.validate();
        String apiVersion = "2016-03-01";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), logProfileName, "2016-03-01", logProfilesResource, context);
    }

    @Override
    public Mono<LogProfileResourceInner> updateAsync(String logProfileName, LogProfileResourcePatch logProfilesResource) {
        return this.updateWithResponseAsync(logProfileName, logProfilesResource).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((LogProfileResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public LogProfileResourceInner update(String logProfileName, LogProfileResourcePatch logProfilesResource) {
        return (LogProfileResourceInner)((Object)this.updateAsync(logProfileName, logProfilesResource).block());
    }

    @Override
    public Response<LogProfileResourceInner> updateWithResponse(String logProfileName, LogProfileResourcePatch logProfilesResource, Context context) {
        return (Response)this.updateWithResponseAsync(logProfileName, logProfilesResource, context).block();
    }

    private Mono<PagedResponse<LogProfileResourceInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2016-03-01";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2016-03-01", this.client.getSubscriptionId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LogProfileCollection)res.getValue()).value(), null, null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<LogProfileResourceInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2016-03-01";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2016-03-01", this.client.getSubscriptionId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LogProfileCollection)res.getValue()).value(), null, null));
    }

    @Override
    public PagedFlux<LogProfileResourceInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync());
    }

    private PagedFlux<LogProfileResourceInner> listAsync(Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(context));
    }

    @Override
    public PagedIterable<LogProfileResourceInner> list() {
        return new PagedIterable(this.listAsync());
    }

    @Override
    public PagedIterable<LogProfileResourceInner> list(Context context) {
        return new PagedIterable(this.listAsync(context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MonitorClientLogProf")
    private static interface LogProfilesService {
        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/providers/microsoft.insights/logprofiles/{logProfileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="logProfileName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/microsoft.insights/logprofiles/{logProfileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LogProfileResourceInner>> get(@HostParam(value="$host") String var1, @PathParam(value="logProfileName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/providers/microsoft.insights/logprofiles/{logProfileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LogProfileResourceInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="logProfileName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @BodyParam(value="application/json") LogProfileResourceInner var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/providers/microsoft.insights/logprofiles/{logProfileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LogProfileResourceInner>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="logProfileName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") LogProfileResourcePatch var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/microsoft.insights/logprofiles")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LogProfileCollection>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, Context var4);
    }
}

