/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.monitor.fluent.MetricAlertsClient;
import com.azure.resourcemanager.monitor.fluent.models.MetricAlertResourceInner;
import com.azure.resourcemanager.monitor.implementation.MonitorClientImpl;
import com.azure.resourcemanager.monitor.models.MetricAlertResourceCollection;
import com.azure.resourcemanager.monitor.models.MetricAlertResourcePatch;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import reactor.core.publisher.Mono;

public final class MetricAlertsClientImpl
implements InnerSupportsGet<MetricAlertResourceInner>,
InnerSupportsListing<MetricAlertResourceInner>,
InnerSupportsDelete<Void>,
MetricAlertsClient {
    private final ClientLogger logger = new ClientLogger(MetricAlertsClientImpl.class);
    private final MetricAlertsService service;
    private final MonitorClientImpl client;

    MetricAlertsClientImpl(MonitorClientImpl client) {
        this.service = (MetricAlertsService)RestProxy.create(MetricAlertsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<MetricAlertResourceInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2018-03-01";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), "2018-03-01", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricAlertResourceCollection)res.getValue()).value(), null, null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MetricAlertResourceInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2018-03-01";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), "2018-03-01", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricAlertResourceCollection)res.getValue()).value(), null, null));
    }

    @Override
    public PagedFlux<MetricAlertResourceInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync());
    }

    private PagedFlux<MetricAlertResourceInner> listAsync(Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(context));
    }

    @Override
    public PagedIterable<MetricAlertResourceInner> list() {
        return new PagedIterable(this.listAsync());
    }

    @Override
    public PagedIterable<MetricAlertResourceInner> list(Context context) {
        return new PagedIterable(this.listAsync(context));
    }

    private Mono<PagedResponse<MetricAlertResourceInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String apiVersion = "2018-03-01";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2018-03-01", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricAlertResourceCollection)res.getValue()).value(), null, null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MetricAlertResourceInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String apiVersion = "2018-03-01";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2018-03-01", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricAlertResourceCollection)res.getValue()).value(), null, null));
    }

    @Override
    public PagedFlux<MetricAlertResourceInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName));
    }

    private PagedFlux<MetricAlertResourceInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, context));
    }

    @Override
    public PagedIterable<MetricAlertResourceInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    public PagedIterable<MetricAlertResourceInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, context));
    }

    @Override
    public Mono<Response<MetricAlertResourceInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String ruleName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ruleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleName is required and cannot be null."));
        }
        String apiVersion = "2018-03-01";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, ruleName, "2018-03-01", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MetricAlertResourceInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String ruleName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ruleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleName is required and cannot be null."));
        }
        String apiVersion = "2018-03-01";
        context = this.client.mergeContext(context);
        return this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, ruleName, "2018-03-01", context);
    }

    @Override
    public Mono<MetricAlertResourceInner> getByResourceGroupAsync(String resourceGroupName, String ruleName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, ruleName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((MetricAlertResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public MetricAlertResourceInner getByResourceGroup(String resourceGroupName, String ruleName) {
        return (MetricAlertResourceInner)((Object)this.getByResourceGroupAsync(resourceGroupName, ruleName).block());
    }

    @Override
    public Response<MetricAlertResourceInner> getByResourceGroupWithResponse(String resourceGroupName, String ruleName, Context context) {
        return (Response)this.getByResourceGroupWithResponseAsync(resourceGroupName, ruleName, context).block();
    }

    @Override
    public Mono<Response<MetricAlertResourceInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String ruleName, MetricAlertResourceInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ruleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2018-03-01";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, ruleName, "2018-03-01", parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MetricAlertResourceInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String ruleName, MetricAlertResourceInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ruleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2018-03-01";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, ruleName, "2018-03-01", parameters, context);
    }

    @Override
    public Mono<MetricAlertResourceInner> createOrUpdateAsync(String resourceGroupName, String ruleName, MetricAlertResourceInner parameters) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, ruleName, parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((MetricAlertResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public MetricAlertResourceInner createOrUpdate(String resourceGroupName, String ruleName, MetricAlertResourceInner parameters) {
        return (MetricAlertResourceInner)((Object)this.createOrUpdateAsync(resourceGroupName, ruleName, parameters).block());
    }

    @Override
    public Response<MetricAlertResourceInner> createOrUpdateWithResponse(String resourceGroupName, String ruleName, MetricAlertResourceInner parameters, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, ruleName, parameters, context).block();
    }

    @Override
    public Mono<Response<MetricAlertResourceInner>> updateWithResponseAsync(String resourceGroupName, String ruleName, MetricAlertResourcePatch parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ruleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2018-03-01";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, ruleName, "2018-03-01", parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MetricAlertResourceInner>> updateWithResponseAsync(String resourceGroupName, String ruleName, MetricAlertResourcePatch parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ruleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2018-03-01";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, ruleName, "2018-03-01", parameters, context);
    }

    @Override
    public Mono<MetricAlertResourceInner> updateAsync(String resourceGroupName, String ruleName, MetricAlertResourcePatch parameters) {
        return this.updateWithResponseAsync(resourceGroupName, ruleName, parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((MetricAlertResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public MetricAlertResourceInner update(String resourceGroupName, String ruleName, MetricAlertResourcePatch parameters) {
        return (MetricAlertResourceInner)((Object)this.updateAsync(resourceGroupName, ruleName, parameters).block());
    }

    @Override
    public Response<MetricAlertResourceInner> updateWithResponse(String resourceGroupName, String ruleName, MetricAlertResourcePatch parameters, Context context) {
        return (Response)this.updateWithResponseAsync(resourceGroupName, ruleName, parameters, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String ruleName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ruleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleName is required and cannot be null."));
        }
        String apiVersion = "2018-03-01";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, ruleName, "2018-03-01", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String ruleName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ruleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleName is required and cannot be null."));
        }
        String apiVersion = "2018-03-01";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, ruleName, "2018-03-01", context);
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String ruleName) {
        return this.deleteWithResponseAsync(resourceGroupName, ruleName).flatMap(res -> Mono.empty());
    }

    @Override
    public void delete(String resourceGroupName, String ruleName) {
        this.deleteAsync(resourceGroupName, ruleName).block();
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String ruleName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, ruleName, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MonitorClientMetricA")
    private static interface MetricAlertsService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Insights/metricAlerts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<MetricAlertResourceCollection>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, Context var4);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/metricAlerts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<MetricAlertResourceCollection>> listByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/metricAlerts/{ruleName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<MetricAlertResourceInner>> getByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="ruleName") String var4, @QueryParam(value="api-version") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/metricAlerts/{ruleName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<MetricAlertResourceInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="ruleName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") MetricAlertResourceInner var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/metricAlerts/{ruleName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<MetricAlertResourceInner>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="ruleName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") MetricAlertResourcePatch var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/metricAlerts/{ruleName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="ruleName") String var4, @QueryParam(value="api-version") String var5, Context var6);
    }
}

