/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.monitor.fluent.MetricDefinitionsClient;
import com.azure.resourcemanager.monitor.fluent.models.MetricDefinitionInner;
import com.azure.resourcemanager.monitor.implementation.MonitorClientImpl;
import com.azure.resourcemanager.monitor.models.MetricDefinitionCollection;
import reactor.core.publisher.Mono;

public final class MetricDefinitionsClientImpl
implements MetricDefinitionsClient {
    private final ClientLogger logger = new ClientLogger(MetricDefinitionsClientImpl.class);
    private final MetricDefinitionsService service;
    private final MonitorClientImpl client;

    MetricDefinitionsClientImpl(MonitorClientImpl client) {
        this.service = (MetricDefinitionsService)RestProxy.create(MetricDefinitionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<MetricDefinitionInner>> listSinglePageAsync(String resourceUri, String metricnamespace) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String apiVersion = "2018-01-01";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceUri, "2018-01-01", metricnamespace, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricDefinitionCollection)res.getValue()).value(), null, null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MetricDefinitionInner>> listSinglePageAsync(String resourceUri, String metricnamespace, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String apiVersion = "2018-01-01";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceUri, "2018-01-01", metricnamespace, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricDefinitionCollection)res.getValue()).value(), null, null));
    }

    @Override
    public PagedFlux<MetricDefinitionInner> listAsync(String resourceUri, String metricnamespace) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceUri, metricnamespace));
    }

    @Override
    public PagedFlux<MetricDefinitionInner> listAsync(String resourceUri) {
        String metricnamespace = null;
        return new PagedFlux(() -> this.listSinglePageAsync(resourceUri, metricnamespace));
    }

    private PagedFlux<MetricDefinitionInner> listAsync(String resourceUri, String metricnamespace, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceUri, metricnamespace, context));
    }

    @Override
    public PagedIterable<MetricDefinitionInner> list(String resourceUri, String metricnamespace, Context context) {
        return new PagedIterable(this.listAsync(resourceUri, metricnamespace, context));
    }

    @Override
    public PagedIterable<MetricDefinitionInner> list(String resourceUri) {
        String metricnamespace = null;
        return new PagedIterable(this.listAsync(resourceUri, metricnamespace));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MonitorClientMetricD")
    private static interface MetricDefinitionsService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/{resourceUri}/providers/microsoft.insights/metricDefinitions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<MetricDefinitionCollection>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceUri", encoded=true) String var2, @QueryParam(value="api-version") String var3, @QueryParam(value="metricnamespace") String var4, Context var5);
    }
}

