/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.monitor.fluent.MetricNamespacesClient;
import com.azure.resourcemanager.monitor.fluent.models.MetricNamespaceInner;
import com.azure.resourcemanager.monitor.implementation.MonitorClientImpl;
import com.azure.resourcemanager.monitor.models.MetricNamespaceCollection;
import reactor.core.publisher.Mono;

public final class MetricNamespacesClientImpl
implements MetricNamespacesClient {
    private final ClientLogger logger = new ClientLogger(MetricNamespacesClientImpl.class);
    private final MetricNamespacesService service;
    private final MonitorClientImpl client;

    MetricNamespacesClientImpl(MonitorClientImpl client) {
        this.service = (MetricNamespacesService)RestProxy.create(MetricNamespacesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<MetricNamespaceInner>> listSinglePageAsync(String resourceUri, String startTime) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String apiVersion = "2017-12-01-preview";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceUri, "2017-12-01-preview", startTime, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricNamespaceCollection)res.getValue()).value(), null, null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MetricNamespaceInner>> listSinglePageAsync(String resourceUri, String startTime, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String apiVersion = "2017-12-01-preview";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceUri, "2017-12-01-preview", startTime, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricNamespaceCollection)res.getValue()).value(), null, null));
    }

    @Override
    public PagedFlux<MetricNamespaceInner> listAsync(String resourceUri, String startTime) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceUri, startTime));
    }

    @Override
    public PagedFlux<MetricNamespaceInner> listAsync(String resourceUri) {
        String startTime = null;
        return new PagedFlux(() -> this.listSinglePageAsync(resourceUri, startTime));
    }

    private PagedFlux<MetricNamespaceInner> listAsync(String resourceUri, String startTime, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceUri, startTime, context));
    }

    @Override
    public PagedIterable<MetricNamespaceInner> list(String resourceUri, String startTime, Context context) {
        return new PagedIterable(this.listAsync(resourceUri, startTime, context));
    }

    @Override
    public PagedIterable<MetricNamespaceInner> list(String resourceUri) {
        String startTime = null;
        return new PagedIterable(this.listAsync(resourceUri, startTime));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MonitorClientMetricN")
    private static interface MetricNamespacesService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/{resourceUri}/providers/microsoft.insights/metricNamespaces")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<MetricNamespaceCollection>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceUri", encoded=true) String var2, @QueryParam(value="api-version") String var3, @QueryParam(value="startTime") String var4, Context var5);
    }
}

