/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.monitor.fluent.TenantActivityLogsClient;
import com.azure.resourcemanager.monitor.fluent.models.EventDataInner;
import com.azure.resourcemanager.monitor.implementation.MonitorClientImpl;
import com.azure.resourcemanager.monitor.models.EventDataCollection;
import reactor.core.publisher.Mono;

public final class TenantActivityLogsClientImpl
implements TenantActivityLogsClient {
    private final ClientLogger logger = new ClientLogger(TenantActivityLogsClientImpl.class);
    private final TenantActivityLogsService service;
    private final MonitorClientImpl client;

    TenantActivityLogsClientImpl(MonitorClientImpl client) {
        this.service = (TenantActivityLogsService)RestProxy.create(TenantActivityLogsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<EventDataInner>> listSinglePageAsync(String filter, String select) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String apiVersion = "2015-04-01";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2015-04-01", filter, select, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventDataCollection)res.getValue()).value(), ((EventDataCollection)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<EventDataInner>> listSinglePageAsync(String filter, String select, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String apiVersion = "2015-04-01";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2015-04-01", filter, select, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventDataCollection)res.getValue()).value(), ((EventDataCollection)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<EventDataInner> listAsync(String filter, String select) {
        return new PagedFlux(() -> this.listSinglePageAsync(filter, select), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<EventDataInner> listAsync() {
        String filter = null;
        String select = null;
        return new PagedFlux(() -> this.listSinglePageAsync(filter, select), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<EventDataInner> listAsync(String filter, String select, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(filter, select, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<EventDataInner> list(String filter, String select, Context context) {
        return new PagedIterable(this.listAsync(filter, select, context));
    }

    @Override
    public PagedIterable<EventDataInner> list() {
        String filter = null;
        String select = null;
        return new PagedIterable(this.listAsync(filter, select));
    }

    private Mono<PagedResponse<EventDataInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventDataCollection)res.getValue()).value(), ((EventDataCollection)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<EventDataInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventDataCollection)res.getValue()).value(), ((EventDataCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MonitorClientTenantA")
    private static interface TenantActivityLogsService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/providers/microsoft.insights/eventtypes/management/values")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventDataCollection>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @QueryParam(value="$filter") String var3, @QueryParam(value="$select") String var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventDataCollection>> listNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

