/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.DynamicThresholdFailingPeriods;
import com.azure.resourcemanager.monitor.models.DynamicThresholdOperator;
import com.azure.resourcemanager.monitor.models.DynamicThresholdSensitivity;
import com.azure.resourcemanager.monitor.models.MultiMetricCriteria;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.OffsetDateTime;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="criterionType")
@JsonTypeName(value="DynamicThresholdCriterion")
public final class DynamicMetricCriteria
extends MultiMetricCriteria {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DynamicMetricCriteria.class);
    @JsonProperty(value="operator", required=true)
    private DynamicThresholdOperator operator;
    @JsonProperty(value="alertSensitivity", required=true)
    private DynamicThresholdSensitivity alertSensitivity;
    @JsonProperty(value="failingPeriods", required=true)
    private DynamicThresholdFailingPeriods failingPeriods;
    @JsonProperty(value="ignoreDataBefore")
    private OffsetDateTime ignoreDataBefore;

    public DynamicThresholdOperator operator() {
        return this.operator;
    }

    public DynamicMetricCriteria withOperator(DynamicThresholdOperator operator) {
        this.operator = operator;
        return this;
    }

    public DynamicThresholdSensitivity alertSensitivity() {
        return this.alertSensitivity;
    }

    public DynamicMetricCriteria withAlertSensitivity(DynamicThresholdSensitivity alertSensitivity) {
        this.alertSensitivity = alertSensitivity;
        return this;
    }

    public DynamicThresholdFailingPeriods failingPeriods() {
        return this.failingPeriods;
    }

    public DynamicMetricCriteria withFailingPeriods(DynamicThresholdFailingPeriods failingPeriods) {
        this.failingPeriods = failingPeriods;
        return this;
    }

    public OffsetDateTime ignoreDataBefore() {
        return this.ignoreDataBefore;
    }

    public DynamicMetricCriteria withIgnoreDataBefore(OffsetDateTime ignoreDataBefore) {
        this.ignoreDataBefore = ignoreDataBefore;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.operator() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property operator in model DynamicMetricCriteria"));
        }
        if (this.alertSensitivity() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property alertSensitivity in model DynamicMetricCriteria"));
        }
        if (this.failingPeriods() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property failingPeriods in model DynamicMetricCriteria"));
        }
        this.failingPeriods().validate();
    }
}

