// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.AutoscaleNotification;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/** The autoscale setting resource. */
@JsonFlatten
@Fluent
public class AutoscaleSettingResourceInner extends Resource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(AutoscaleSettingResourceInner.class);

    /*
     * the collection of automatic scaling profiles that specify different
     * scaling parameters for different time periods. A maximum of 20 profiles
     * can be specified.
     */
    @JsonProperty(value = "properties.profiles", required = true)
    private List<AutoscaleProfileInner> profiles;

    /*
     * the collection of notifications.
     */
    @JsonProperty(value = "properties.notifications")
    private List<AutoscaleNotification> notifications;

    /*
     * the enabled flag. Specifies whether automatic scaling is enabled for the
     * resource. The default value is 'true'.
     */
    @JsonProperty(value = "properties.enabled")
    private Boolean enabled;

    /*
     * the name of the autoscale setting.
     */
    @JsonProperty(value = "properties.name")
    private String namePropertiesName;

    /*
     * the resource identifier of the resource that the autoscale setting
     * should be added to.
     */
    @JsonProperty(value = "properties.targetResourceUri")
    private String targetResourceUri;

    /*
     * the location of the resource that the autoscale setting should be added
     * to.
     */
    @JsonProperty(value = "properties.targetResourceLocation")
    private String targetResourceLocation;

    /**
     * Get the profiles property: the collection of automatic scaling profiles that specify different scaling parameters
     * for different time periods. A maximum of 20 profiles can be specified.
     *
     * @return the profiles value.
     */
    public List<AutoscaleProfileInner> profiles() {
        return this.profiles;
    }

    /**
     * Set the profiles property: the collection of automatic scaling profiles that specify different scaling parameters
     * for different time periods. A maximum of 20 profiles can be specified.
     *
     * @param profiles the profiles value to set.
     * @return the AutoscaleSettingResourceInner object itself.
     */
    public AutoscaleSettingResourceInner withProfiles(List<AutoscaleProfileInner> profiles) {
        this.profiles = profiles;
        return this;
    }

    /**
     * Get the notifications property: the collection of notifications.
     *
     * @return the notifications value.
     */
    public List<AutoscaleNotification> notifications() {
        return this.notifications;
    }

    /**
     * Set the notifications property: the collection of notifications.
     *
     * @param notifications the notifications value to set.
     * @return the AutoscaleSettingResourceInner object itself.
     */
    public AutoscaleSettingResourceInner withNotifications(List<AutoscaleNotification> notifications) {
        this.notifications = notifications;
        return this;
    }

    /**
     * Get the enabled property: the enabled flag. Specifies whether automatic scaling is enabled for the resource. The
     * default value is 'true'.
     *
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: the enabled flag. Specifies whether automatic scaling is enabled for the resource. The
     * default value is 'true'.
     *
     * @param enabled the enabled value to set.
     * @return the AutoscaleSettingResourceInner object itself.
     */
    public AutoscaleSettingResourceInner withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the namePropertiesName property: the name of the autoscale setting.
     *
     * @return the namePropertiesName value.
     */
    public String namePropertiesName() {
        return this.namePropertiesName;
    }

    /**
     * Set the namePropertiesName property: the name of the autoscale setting.
     *
     * @param namePropertiesName the namePropertiesName value to set.
     * @return the AutoscaleSettingResourceInner object itself.
     */
    public AutoscaleSettingResourceInner withNamePropertiesName(String namePropertiesName) {
        this.namePropertiesName = namePropertiesName;
        return this;
    }

    /**
     * Get the targetResourceUri property: the resource identifier of the resource that the autoscale setting should be
     * added to.
     *
     * @return the targetResourceUri value.
     */
    public String targetResourceUri() {
        return this.targetResourceUri;
    }

    /**
     * Set the targetResourceUri property: the resource identifier of the resource that the autoscale setting should be
     * added to.
     *
     * @param targetResourceUri the targetResourceUri value to set.
     * @return the AutoscaleSettingResourceInner object itself.
     */
    public AutoscaleSettingResourceInner withTargetResourceUri(String targetResourceUri) {
        this.targetResourceUri = targetResourceUri;
        return this;
    }

    /**
     * Get the targetResourceLocation property: the location of the resource that the autoscale setting should be added
     * to.
     *
     * @return the targetResourceLocation value.
     */
    public String targetResourceLocation() {
        return this.targetResourceLocation;
    }

    /**
     * Set the targetResourceLocation property: the location of the resource that the autoscale setting should be added
     * to.
     *
     * @param targetResourceLocation the targetResourceLocation value to set.
     * @return the AutoscaleSettingResourceInner object itself.
     */
    public AutoscaleSettingResourceInner withTargetResourceLocation(String targetResourceLocation) {
        this.targetResourceLocation = targetResourceLocation;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public AutoscaleSettingResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public AutoscaleSettingResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (profiles() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property profiles in model AutoscaleSettingResourceInner"));
        } else {
            profiles().forEach(e -> e.validate());
        }
        if (notifications() != null) {
            notifications().forEach(e -> e.validate());
        }
    }
}
