// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Definition of which streams are sent to which destinations. */
@Fluent
public final class DataFlow {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(DataFlow.class);

    /*
     * List of streams for this data flow.
     */
    @JsonProperty(value = "streams")
    private List<KnownDataFlowStreams> streams;

    /*
     * List of destinations for this data flow.
     */
    @JsonProperty(value = "destinations")
    private List<String> destinations;

    /**
     * Get the streams property: List of streams for this data flow.
     *
     * @return the streams value.
     */
    public List<KnownDataFlowStreams> streams() {
        return this.streams;
    }

    /**
     * Set the streams property: List of streams for this data flow.
     *
     * @param streams the streams value to set.
     * @return the DataFlow object itself.
     */
    public DataFlow withStreams(List<KnownDataFlowStreams> streams) {
        this.streams = streams;
        return this;
    }

    /**
     * Get the destinations property: List of destinations for this data flow.
     *
     * @return the destinations value.
     */
    public List<String> destinations() {
        return this.destinations;
    }

    /**
     * Set the destinations property: List of destinations for this data flow.
     *
     * @param destinations the destinations value to set.
     * @return the DataFlow object itself.
     */
    public DataFlow withDestinations(List<String> destinations) {
        this.destinations = destinations;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
