// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.fluent.DataCollectionRulesClient;
import com.azure.resourcemanager.monitor.fluent.models.DataCollectionRuleResourceInner;
import com.azure.resourcemanager.monitor.models.DataCollectionRuleResourceListResult;
import com.azure.resourcemanager.monitor.models.ResourceForUpdate;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.util.Map;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in DataCollectionRulesClient. */
public final class DataCollectionRulesClientImpl
    implements InnerSupportsGet<DataCollectionRuleResourceInner>,
        InnerSupportsListing<DataCollectionRuleResourceInner>,
        InnerSupportsDelete<Void>,
        DataCollectionRulesClient {
    private final ClientLogger logger = new ClientLogger(DataCollectionRulesClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final DataCollectionRulesService service;

    /** The service client containing this operation class. */
    private final MonitorClientImpl client;

    /**
     * Initializes an instance of DataCollectionRulesClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    DataCollectionRulesClientImpl(MonitorClientImpl client) {
        this.service =
            RestProxy.create(DataCollectionRulesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for MonitorClientDataCollectionRules to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "MonitorClientDataCol")
    private interface DataCollectionRulesService {
        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights"
                + "/dataCollectionRules")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DataCollectionRuleResourceListResult>> listByResourceGroup(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Insights/dataCollectionRules")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DataCollectionRuleResourceListResult>> list(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights"
                + "/dataCollectionRules/{dataCollectionRuleName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DataCollectionRuleResourceInner>> getByResourceGroup(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("dataCollectionRuleName") String dataCollectionRuleName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights"
                + "/dataCollectionRules/{dataCollectionRuleName}")
        @ExpectedResponses({200, 201})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DataCollectionRuleResourceInner>> create(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("dataCollectionRuleName") String dataCollectionRuleName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") DataCollectionRuleResourceInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights"
                + "/dataCollectionRules/{dataCollectionRuleName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DataCollectionRuleResourceInner>> update(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("dataCollectionRuleName") String dataCollectionRuleName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ResourceForUpdate body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights"
                + "/dataCollectionRules/{dataCollectionRuleName}")
        @ExpectedResponses({200, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> delete(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("dataCollectionRuleName") String dataCollectionRuleName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DataCollectionRuleResourceListResult>> listByResourceGroupNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DataCollectionRuleResourceListResult>> listBySubscriptionNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Lists all data collection rules in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a pageable list of resources.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DataCollectionRuleResourceInner>> listByResourceGroupSinglePageAsync(
        String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        final String apiVersion = "2021-04-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listByResourceGroup(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            apiVersion,
                            accept,
                            context))
            .<PagedResponse<DataCollectionRuleResourceInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists all data collection rules in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a pageable list of resources.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DataCollectionRuleResourceInner>> listByResourceGroupSinglePageAsync(
        String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        final String apiVersion = "2021-04-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroup(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                apiVersion,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Lists all data collection rules in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a pageable list of resources.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DataCollectionRuleResourceInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux<>(
            () -> listByResourceGroupSinglePageAsync(resourceGroupName),
            nextLink -> listByResourceGroupNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all data collection rules in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a pageable list of resources.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DataCollectionRuleResourceInner> listByResourceGroupAsync(
        String resourceGroupName, Context context) {
        return new PagedFlux<>(
            () -> listByResourceGroupSinglePageAsync(resourceGroupName, context),
            nextLink -> listByResourceGroupNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists all data collection rules in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a pageable list of resources.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DataCollectionRuleResourceInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName));
    }

    /**
     * Lists all data collection rules in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a pageable list of resources.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DataCollectionRuleResourceInner> listByResourceGroup(
        String resourceGroupName, Context context) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, context));
    }

    /**
     * Lists all data collection rules in the specified subscription.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a pageable list of resources.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DataCollectionRuleResourceInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-04-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .list(this.client.getEndpoint(), this.client.getSubscriptionId(), apiVersion, accept, context))
            .<PagedResponse<DataCollectionRuleResourceInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists all data collection rules in the specified subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a pageable list of resources.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DataCollectionRuleResourceInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-04-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), this.client.getSubscriptionId(), apiVersion, accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Lists all data collection rules in the specified subscription.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a pageable list of resources.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DataCollectionRuleResourceInner> listAsync() {
        return new PagedFlux<>(
            () -> listSinglePageAsync(), nextLink -> listBySubscriptionNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all data collection rules in the specified subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a pageable list of resources.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DataCollectionRuleResourceInner> listAsync(Context context) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(context), nextLink -> listBySubscriptionNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists all data collection rules in the specified subscription.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a pageable list of resources.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DataCollectionRuleResourceInner> list() {
        return new PagedIterable<>(listAsync());
    }

    /**
     * Lists all data collection rules in the specified subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a pageable list of resources.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DataCollectionRuleResourceInner> list(Context context) {
        return new PagedIterable<>(listAsync(context));
    }

    /**
     * Returns the specified data collection rule.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param dataCollectionRuleName The name of the data collection rule. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of ARM tracked top level resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DataCollectionRuleResourceInner>> getByResourceGroupWithResponseAsync(
        String resourceGroupName, String dataCollectionRuleName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dataCollectionRuleName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter dataCollectionRuleName is required and cannot be null."));
        }
        final String apiVersion = "2021-04-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getByResourceGroup(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            dataCollectionRuleName,
                            apiVersion,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Returns the specified data collection rule.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param dataCollectionRuleName The name of the data collection rule. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of ARM tracked top level resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DataCollectionRuleResourceInner>> getByResourceGroupWithResponseAsync(
        String resourceGroupName, String dataCollectionRuleName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dataCollectionRuleName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter dataCollectionRuleName is required and cannot be null."));
        }
        final String apiVersion = "2021-04-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getByResourceGroup(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                dataCollectionRuleName,
                apiVersion,
                accept,
                context);
    }

    /**
     * Returns the specified data collection rule.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param dataCollectionRuleName The name of the data collection rule. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of ARM tracked top level resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DataCollectionRuleResourceInner> getByResourceGroupAsync(
        String resourceGroupName, String dataCollectionRuleName) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, dataCollectionRuleName)
            .flatMap(
                (Response<DataCollectionRuleResourceInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Returns the specified data collection rule.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param dataCollectionRuleName The name of the data collection rule. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of ARM tracked top level resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DataCollectionRuleResourceInner getByResourceGroup(String resourceGroupName, String dataCollectionRuleName) {
        return getByResourceGroupAsync(resourceGroupName, dataCollectionRuleName).block();
    }

    /**
     * Returns the specified data collection rule.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param dataCollectionRuleName The name of the data collection rule. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of ARM tracked top level resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DataCollectionRuleResourceInner> getByResourceGroupWithResponse(
        String resourceGroupName, String dataCollectionRuleName, Context context) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, dataCollectionRuleName, context).block();
    }

    /**
     * Creates or updates a data collection rule.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param dataCollectionRuleName The name of the data collection rule. The name is case insensitive.
     * @param body The payload.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of ARM tracked top level resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DataCollectionRuleResourceInner>> createWithResponseAsync(
        String resourceGroupName, String dataCollectionRuleName, DataCollectionRuleResourceInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dataCollectionRuleName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter dataCollectionRuleName is required and cannot be null."));
        }
        if (body != null) {
            body.validate();
        }
        final String apiVersion = "2021-04-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .create(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            dataCollectionRuleName,
                            apiVersion,
                            body,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates or updates a data collection rule.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param dataCollectionRuleName The name of the data collection rule. The name is case insensitive.
     * @param body The payload.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of ARM tracked top level resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DataCollectionRuleResourceInner>> createWithResponseAsync(
        String resourceGroupName,
        String dataCollectionRuleName,
        DataCollectionRuleResourceInner body,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dataCollectionRuleName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter dataCollectionRuleName is required and cannot be null."));
        }
        if (body != null) {
            body.validate();
        }
        final String apiVersion = "2021-04-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .create(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                dataCollectionRuleName,
                apiVersion,
                body,
                accept,
                context);
    }

    /**
     * Creates or updates a data collection rule.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param dataCollectionRuleName The name of the data collection rule. The name is case insensitive.
     * @param body The payload.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of ARM tracked top level resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DataCollectionRuleResourceInner> createAsync(
        String resourceGroupName, String dataCollectionRuleName, DataCollectionRuleResourceInner body) {
        return createWithResponseAsync(resourceGroupName, dataCollectionRuleName, body)
            .flatMap(
                (Response<DataCollectionRuleResourceInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Creates or updates a data collection rule.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param dataCollectionRuleName The name of the data collection rule. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of ARM tracked top level resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DataCollectionRuleResourceInner> createAsync(String resourceGroupName, String dataCollectionRuleName) {
        final DataCollectionRuleResourceInner body = null;
        return createWithResponseAsync(resourceGroupName, dataCollectionRuleName, body)
            .flatMap(
                (Response<DataCollectionRuleResourceInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Creates or updates a data collection rule.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param dataCollectionRuleName The name of the data collection rule. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of ARM tracked top level resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DataCollectionRuleResourceInner create(String resourceGroupName, String dataCollectionRuleName) {
        final DataCollectionRuleResourceInner body = null;
        return createAsync(resourceGroupName, dataCollectionRuleName, body).block();
    }

    /**
     * Creates or updates a data collection rule.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param dataCollectionRuleName The name of the data collection rule. The name is case insensitive.
     * @param body The payload.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of ARM tracked top level resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DataCollectionRuleResourceInner> createWithResponse(
        String resourceGroupName,
        String dataCollectionRuleName,
        DataCollectionRuleResourceInner body,
        Context context) {
        return createWithResponseAsync(resourceGroupName, dataCollectionRuleName, body, context).block();
    }

    /**
     * Updates part of a data collection rule.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param dataCollectionRuleName The name of the data collection rule. The name is case insensitive.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of ARM tracked top level resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DataCollectionRuleResourceInner>> updateWithResponseAsync(
        String resourceGroupName, String dataCollectionRuleName, Map<String, String> tags) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dataCollectionRuleName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter dataCollectionRuleName is required and cannot be null."));
        }
        final String apiVersion = "2021-04-01";
        final String accept = "application/json";
        ResourceForUpdate bodyInternal = null;
        if (tags != null) {
            bodyInternal = new ResourceForUpdate();
            bodyInternal.withTags(tags);
        }
        ResourceForUpdate body = bodyInternal;
        return FluxUtil
            .withContext(
                context ->
                    service
                        .update(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            dataCollectionRuleName,
                            apiVersion,
                            body,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates part of a data collection rule.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param dataCollectionRuleName The name of the data collection rule. The name is case insensitive.
     * @param tags Resource tags.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of ARM tracked top level resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DataCollectionRuleResourceInner>> updateWithResponseAsync(
        String resourceGroupName, String dataCollectionRuleName, Map<String, String> tags, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dataCollectionRuleName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter dataCollectionRuleName is required and cannot be null."));
        }
        final String apiVersion = "2021-04-01";
        final String accept = "application/json";
        ResourceForUpdate bodyInternal = null;
        if (tags != null) {
            bodyInternal = new ResourceForUpdate();
            bodyInternal.withTags(tags);
        }
        ResourceForUpdate body = bodyInternal;
        context = this.client.mergeContext(context);
        return service
            .update(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                dataCollectionRuleName,
                apiVersion,
                body,
                accept,
                context);
    }

    /**
     * Updates part of a data collection rule.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param dataCollectionRuleName The name of the data collection rule. The name is case insensitive.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of ARM tracked top level resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DataCollectionRuleResourceInner> updateAsync(
        String resourceGroupName, String dataCollectionRuleName, Map<String, String> tags) {
        return updateWithResponseAsync(resourceGroupName, dataCollectionRuleName, tags)
            .flatMap(
                (Response<DataCollectionRuleResourceInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Updates part of a data collection rule.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param dataCollectionRuleName The name of the data collection rule. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of ARM tracked top level resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DataCollectionRuleResourceInner> updateAsync(String resourceGroupName, String dataCollectionRuleName) {
        final Map<String, String> tags = null;
        return updateWithResponseAsync(resourceGroupName, dataCollectionRuleName, tags)
            .flatMap(
                (Response<DataCollectionRuleResourceInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Updates part of a data collection rule.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param dataCollectionRuleName The name of the data collection rule. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of ARM tracked top level resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DataCollectionRuleResourceInner update(String resourceGroupName, String dataCollectionRuleName) {
        final Map<String, String> tags = null;
        return updateAsync(resourceGroupName, dataCollectionRuleName, tags).block();
    }

    /**
     * Updates part of a data collection rule.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param dataCollectionRuleName The name of the data collection rule. The name is case insensitive.
     * @param tags Resource tags.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return definition of ARM tracked top level resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DataCollectionRuleResourceInner> updateWithResponse(
        String resourceGroupName, String dataCollectionRuleName, Map<String, String> tags, Context context) {
        return updateWithResponseAsync(resourceGroupName, dataCollectionRuleName, tags, context).block();
    }

    /**
     * Deletes a data collection rule.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param dataCollectionRuleName The name of the data collection rule. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String dataCollectionRuleName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dataCollectionRuleName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter dataCollectionRuleName is required and cannot be null."));
        }
        final String apiVersion = "2021-04-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            dataCollectionRuleName,
                            apiVersion,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a data collection rule.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param dataCollectionRuleName The name of the data collection rule. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(
        String resourceGroupName, String dataCollectionRuleName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dataCollectionRuleName == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter dataCollectionRuleName is required and cannot be null."));
        }
        final String apiVersion = "2021-04-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .delete(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                dataCollectionRuleName,
                apiVersion,
                accept,
                context);
    }

    /**
     * Deletes a data collection rule.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param dataCollectionRuleName The name of the data collection rule. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String dataCollectionRuleName) {
        return deleteWithResponseAsync(resourceGroupName, dataCollectionRuleName)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Deletes a data collection rule.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param dataCollectionRuleName The name of the data collection rule. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String dataCollectionRuleName) {
        deleteAsync(resourceGroupName, dataCollectionRuleName).block();
    }

    /**
     * Deletes a data collection rule.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param dataCollectionRuleName The name of the data collection rule. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String dataCollectionRuleName, Context context) {
        return deleteWithResponseAsync(resourceGroupName, dataCollectionRuleName, context).block();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a pageable list of resources.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DataCollectionRuleResourceInner>> listByResourceGroupNextSinglePageAsync(
        String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<DataCollectionRuleResourceInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a pageable list of resources.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DataCollectionRuleResourceInner>> listByResourceGroupNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroupNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a pageable list of resources.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DataCollectionRuleResourceInner>> listBySubscriptionNextSinglePageAsync(
        String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<DataCollectionRuleResourceInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a pageable list of resources.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DataCollectionRuleResourceInner>> listBySubscriptionNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listBySubscriptionNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
