// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Definition of what monitoring data to collect and where that data should be sent. */
@Fluent
public class DataCollectionRule {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(DataCollectionRule.class);

    /*
     * Description of the data collection rule.
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * The immutable ID of this data collection rule. This property is
     * READ-ONLY.
     */
    @JsonProperty(value = "immutableId", access = JsonProperty.Access.WRITE_ONLY)
    private String immutableId;

    /*
     * The specification of data sources.
     * This property is optional and can be omitted if the rule is meant to be
     * used via direct calls to the provisioned endpoint.
     */
    @JsonProperty(value = "dataSources")
    private DataCollectionRuleDataSources dataSources;

    /*
     * The specification of destinations.
     */
    @JsonProperty(value = "destinations")
    private DataCollectionRuleDestinations destinations;

    /*
     * The specification of data flows.
     */
    @JsonProperty(value = "dataFlows")
    private List<DataFlow> dataFlows;

    /*
     * The resource provisioning state.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private KnownDataCollectionRuleProvisioningState provisioningState;

    /**
     * Get the description property: Description of the data collection rule.
     *
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Description of the data collection rule.
     *
     * @param description the description value to set.
     * @return the DataCollectionRule object itself.
     */
    public DataCollectionRule withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the immutableId property: The immutable ID of this data collection rule. This property is READ-ONLY.
     *
     * @return the immutableId value.
     */
    public String immutableId() {
        return this.immutableId;
    }

    /**
     * Get the dataSources property: The specification of data sources. This property is optional and can be omitted if
     * the rule is meant to be used via direct calls to the provisioned endpoint.
     *
     * @return the dataSources value.
     */
    public DataCollectionRuleDataSources dataSources() {
        return this.dataSources;
    }

    /**
     * Set the dataSources property: The specification of data sources. This property is optional and can be omitted if
     * the rule is meant to be used via direct calls to the provisioned endpoint.
     *
     * @param dataSources the dataSources value to set.
     * @return the DataCollectionRule object itself.
     */
    public DataCollectionRule withDataSources(DataCollectionRuleDataSources dataSources) {
        this.dataSources = dataSources;
        return this;
    }

    /**
     * Get the destinations property: The specification of destinations.
     *
     * @return the destinations value.
     */
    public DataCollectionRuleDestinations destinations() {
        return this.destinations;
    }

    /**
     * Set the destinations property: The specification of destinations.
     *
     * @param destinations the destinations value to set.
     * @return the DataCollectionRule object itself.
     */
    public DataCollectionRule withDestinations(DataCollectionRuleDestinations destinations) {
        this.destinations = destinations;
        return this;
    }

    /**
     * Get the dataFlows property: The specification of data flows.
     *
     * @return the dataFlows value.
     */
    public List<DataFlow> dataFlows() {
        return this.dataFlows;
    }

    /**
     * Set the dataFlows property: The specification of data flows.
     *
     * @param dataFlows the dataFlows value to set.
     * @return the DataCollectionRule object itself.
     */
    public DataCollectionRule withDataFlows(List<DataFlow> dataFlows) {
        this.dataFlows = dataFlows;
        return this;
    }

    /**
     * Get the provisioningState property: The resource provisioning state.
     *
     * @return the provisioningState value.
     */
    public KnownDataCollectionRuleProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (dataSources() != null) {
            dataSources().validate();
        }
        if (destinations() != null) {
            destinations().validate();
        }
        if (dataFlows() != null) {
            dataFlows().forEach(e -> e.validate());
        }
    }
}
