// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;

/**
 * The specification of data sources. This property is optional and can be omitted if the rule is meant to be used via
 * direct calls to the provisioned endpoint.
 */
@Fluent
public final class DataCollectionRuleDataSources extends DataSourcesSpec {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(DataCollectionRuleDataSources.class);

    /** {@inheritDoc} */
    @Override
    public DataCollectionRuleDataSources withPerformanceCounters(List<PerfCounterDataSource> performanceCounters) {
        super.withPerformanceCounters(performanceCounters);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public DataCollectionRuleDataSources withWindowsEventLogs(List<WindowsEventLogDataSource> windowsEventLogs) {
        super.withWindowsEventLogs(windowsEventLogs);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public DataCollectionRuleDataSources withSyslog(List<SyslogDataSource> syslog) {
        super.withSyslog(syslog);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public DataCollectionRuleDataSources withExtensions(List<ExtensionDataSource> extensions) {
        super.withExtensions(extensions);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
