// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for KnownPerfCounterDataSourceStreams. */
public final class KnownPerfCounterDataSourceStreams extends ExpandableStringEnum<KnownPerfCounterDataSourceStreams> {
    /** Static value Microsoft-Perf for KnownPerfCounterDataSourceStreams. */
    public static final KnownPerfCounterDataSourceStreams MICROSOFT_PERF = fromString("Microsoft-Perf");

    /** Static value Microsoft-InsightsMetrics for KnownPerfCounterDataSourceStreams. */
    public static final KnownPerfCounterDataSourceStreams MICROSOFT_INSIGHTS_METRICS =
        fromString("Microsoft-InsightsMetrics");

    /**
     * Creates or finds a KnownPerfCounterDataSourceStreams from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding KnownPerfCounterDataSourceStreams.
     */
    @JsonCreator
    public static KnownPerfCounterDataSourceStreams fromString(String name) {
        return fromString(name, KnownPerfCounterDataSourceStreams.class);
    }

    /** @return known KnownPerfCounterDataSourceStreams values. */
    public static Collection<KnownPerfCounterDataSourceStreams> values() {
        return values(KnownPerfCounterDataSourceStreams.class);
    }
}
