// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** The log search rule resource for patch operations. */
@JsonFlatten
@Fluent
public class LogSearchRuleResourcePatch {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(LogSearchRuleResourcePatch.class);

    /*
     * Resource tags
     */
    @JsonProperty(value = "tags")
    private Map<String, String> tags;

    /*
     * The flag which indicates whether the Log Search rule is enabled. Value
     * should be true or false
     */
    @JsonProperty(value = "properties.enabled")
    private Enabled enabled;

    /**
     * Get the tags property: Resource tags.
     *
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Resource tags.
     *
     * @param tags the tags value to set.
     * @return the LogSearchRuleResourcePatch object itself.
     */
    public LogSearchRuleResourcePatch withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the enabled property: The flag which indicates whether the Log Search rule is enabled. Value should be true
     * or false.
     *
     * @return the enabled value.
     */
    public Enabled enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: The flag which indicates whether the Log Search rule is enabled. Value should be true
     * or false.
     *
     * @param enabled the enabled value to set.
     * @return the LogSearchRuleResourcePatch object itself.
     */
    public LogSearchRuleResourcePatch withEnabled(Enabled enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
