// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for KnownPublicNetworkAccessOptions. */
public final class KnownPublicNetworkAccessOptions extends ExpandableStringEnum<KnownPublicNetworkAccessOptions> {
    /** Static value Enabled for KnownPublicNetworkAccessOptions. */
    public static final KnownPublicNetworkAccessOptions ENABLED = fromString("Enabled");

    /** Static value Disabled for KnownPublicNetworkAccessOptions. */
    public static final KnownPublicNetworkAccessOptions DISABLED = fromString("Disabled");

    /**
     * Creates or finds a KnownPublicNetworkAccessOptions from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding KnownPublicNetworkAccessOptions.
     */
    @JsonCreator
    public static KnownPublicNetworkAccessOptions fromString(String name) {
        return fromString(name, KnownPublicNetworkAccessOptions.class);
    }

    /** @return known KnownPublicNetworkAccessOptions values. */
    public static Collection<KnownPublicNetworkAccessOptions> values() {
        return values(KnownPublicNetworkAccessOptions.class);
    }
}
