// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.DataCollectionRuleDataSources;
import com.azure.resourcemanager.monitor.models.DataCollectionRuleDestinations;
import com.azure.resourcemanager.monitor.models.DataFlow;
import com.azure.resourcemanager.monitor.models.KnownDataCollectionRuleProvisioningState;
import com.azure.resourcemanager.monitor.models.KnownDataCollectionRuleResourceKind;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/** Definition of ARM tracked top level resource. */
@JsonFlatten
@Fluent
public class DataCollectionRuleResourceInner extends Resource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(DataCollectionRuleResourceInner.class);

    /*
     * The kind of the resource.
     */
    @JsonProperty(value = "kind")
    private KnownDataCollectionRuleResourceKind kind;

    /*
     * Resource entity tag (ETag).
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /*
     * Metadata pertaining to creation and last modification of the resource.
     */
    @JsonProperty(value = "systemData", access = JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    /*
     * Description of the data collection rule.
     */
    @JsonProperty(value = "properties.description")
    private String description;

    /*
     * The immutable ID of this data collection rule. This property is
     * READ-ONLY.
     */
    @JsonProperty(value = "properties.immutableId", access = JsonProperty.Access.WRITE_ONLY)
    private String immutableId;

    /*
     * The specification of data sources.
     * This property is optional and can be omitted if the rule is meant to be
     * used via direct calls to the provisioned endpoint.
     */
    @JsonProperty(value = "properties.dataSources")
    private DataCollectionRuleDataSources dataSources;

    /*
     * The specification of destinations.
     */
    @JsonProperty(value = "properties.destinations")
    private DataCollectionRuleDestinations destinations;

    /*
     * The specification of data flows.
     */
    @JsonProperty(value = "properties.dataFlows")
    private List<DataFlow> dataFlows;

    /*
     * The resource provisioning state.
     */
    @JsonProperty(value = "properties.provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private KnownDataCollectionRuleProvisioningState provisioningState;

    /**
     * Get the kind property: The kind of the resource.
     *
     * @return the kind value.
     */
    public KnownDataCollectionRuleResourceKind kind() {
        return this.kind;
    }

    /**
     * Set the kind property: The kind of the resource.
     *
     * @param kind the kind value to set.
     * @return the DataCollectionRuleResourceInner object itself.
     */
    public DataCollectionRuleResourceInner withKind(KnownDataCollectionRuleResourceKind kind) {
        this.kind = kind;
        return this;
    }

    /**
     * Get the etag property: Resource entity tag (ETag).
     *
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the systemData property: Metadata pertaining to creation and last modification of the resource.
     *
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the description property: Description of the data collection rule.
     *
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Description of the data collection rule.
     *
     * @param description the description value to set.
     * @return the DataCollectionRuleResourceInner object itself.
     */
    public DataCollectionRuleResourceInner withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the immutableId property: The immutable ID of this data collection rule. This property is READ-ONLY.
     *
     * @return the immutableId value.
     */
    public String immutableId() {
        return this.immutableId;
    }

    /**
     * Get the dataSources property: The specification of data sources. This property is optional and can be omitted if
     * the rule is meant to be used via direct calls to the provisioned endpoint.
     *
     * @return the dataSources value.
     */
    public DataCollectionRuleDataSources dataSources() {
        return this.dataSources;
    }

    /**
     * Set the dataSources property: The specification of data sources. This property is optional and can be omitted if
     * the rule is meant to be used via direct calls to the provisioned endpoint.
     *
     * @param dataSources the dataSources value to set.
     * @return the DataCollectionRuleResourceInner object itself.
     */
    public DataCollectionRuleResourceInner withDataSources(DataCollectionRuleDataSources dataSources) {
        this.dataSources = dataSources;
        return this;
    }

    /**
     * Get the destinations property: The specification of destinations.
     *
     * @return the destinations value.
     */
    public DataCollectionRuleDestinations destinations() {
        return this.destinations;
    }

    /**
     * Set the destinations property: The specification of destinations.
     *
     * @param destinations the destinations value to set.
     * @return the DataCollectionRuleResourceInner object itself.
     */
    public DataCollectionRuleResourceInner withDestinations(DataCollectionRuleDestinations destinations) {
        this.destinations = destinations;
        return this;
    }

    /**
     * Get the dataFlows property: The specification of data flows.
     *
     * @return the dataFlows value.
     */
    public List<DataFlow> dataFlows() {
        return this.dataFlows;
    }

    /**
     * Set the dataFlows property: The specification of data flows.
     *
     * @param dataFlows the dataFlows value to set.
     * @return the DataCollectionRuleResourceInner object itself.
     */
    public DataCollectionRuleResourceInner withDataFlows(List<DataFlow> dataFlows) {
        this.dataFlows = dataFlows;
        return this;
    }

    /**
     * Get the provisioningState property: The resource provisioning state.
     *
     * @return the provisioningState value.
     */
    public KnownDataCollectionRuleProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /** {@inheritDoc} */
    @Override
    public DataCollectionRuleResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public DataCollectionRuleResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (dataSources() != null) {
            dataSources().validate();
        }
        if (destinations() != null) {
            destinations().validate();
        }
        if (dataFlows() != null) {
            dataFlows().forEach(e -> e.validate());
        }
    }
}
