// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;

/** Resource properties. */
@Fluent
public final class DataCollectionEndpointResourceProperties extends DataCollectionEndpoint {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(DataCollectionEndpointResourceProperties.class);

    /** {@inheritDoc} */
    @Override
    public DataCollectionEndpointResourceProperties withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public DataCollectionEndpointResourceProperties withImmutableId(String immutableId) {
        super.withImmutableId(immutableId);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public DataCollectionEndpointResourceProperties withConfigurationAccess(
        DataCollectionEndpointConfigurationAccess configurationAccess) {
        super.withConfigurationAccess(configurationAccess);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public DataCollectionEndpointResourceProperties withLogsIngestion(
        DataCollectionEndpointLogsIngestion logsIngestion) {
        super.withLogsIngestion(logsIngestion);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public DataCollectionEndpointResourceProperties withNetworkAcls(DataCollectionEndpointNetworkAcls networkAcls) {
        super.withNetworkAcls(networkAcls);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
