// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.fluent.models.IncidentInner;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The List incidents operation response. */
@Fluent
public final class IncidentListResult {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(IncidentListResult.class);

    /*
     * the incident collection.
     */
    @JsonProperty(value = "value")
    private List<IncidentInner> value;

    /**
     * Get the value property: the incident collection.
     *
     * @return the value value.
     */
    public List<IncidentInner> value() {
        return this.value;
    }

    /**
     * Set the value property: the incident collection.
     *
     * @param value the value value to set.
     * @return the IncidentListResult object itself.
     */
    public IncidentListResult withValue(List<IncidentInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
