/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.Action;
import com.azure.resourcemanager.monitor.models.Enabled;
import com.azure.resourcemanager.monitor.models.ProvisioningState;
import com.azure.resourcemanager.monitor.models.Schedule;
import com.azure.resourcemanager.monitor.models.Source;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

public final class LogSearchRule {
    @JsonProperty(value="createdWithApiVersion", access=JsonProperty.Access.WRITE_ONLY)
    private String createdWithApiVersion;
    @JsonProperty(value="isLegacyLogAnalyticsRule", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean isLegacyLogAnalyticsRule;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="displayName")
    private String displayName;
    @JsonProperty(value="autoMitigate")
    private Boolean autoMitigate;
    @JsonProperty(value="enabled")
    private Enabled enabled;
    @JsonProperty(value="lastUpdatedTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastUpdatedTime;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="source", required=true)
    private Source source;
    @JsonProperty(value="schedule")
    private Schedule schedule;
    @JsonProperty(value="action", required=true)
    private Action action;
    private static final ClientLogger LOGGER = new ClientLogger(LogSearchRule.class);

    public String createdWithApiVersion() {
        return this.createdWithApiVersion;
    }

    public Boolean isLegacyLogAnalyticsRule() {
        return this.isLegacyLogAnalyticsRule;
    }

    public String description() {
        return this.description;
    }

    public LogSearchRule withDescription(String description) {
        this.description = description;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public LogSearchRule withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public Boolean autoMitigate() {
        return this.autoMitigate;
    }

    public LogSearchRule withAutoMitigate(Boolean autoMitigate) {
        this.autoMitigate = autoMitigate;
        return this;
    }

    public Enabled enabled() {
        return this.enabled;
    }

    public LogSearchRule withEnabled(Enabled enabled) {
        this.enabled = enabled;
        return this;
    }

    public OffsetDateTime lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Source source() {
        return this.source;
    }

    public LogSearchRule withSource(Source source) {
        this.source = source;
        return this;
    }

    public Schedule schedule() {
        return this.schedule;
    }

    public LogSearchRule withSchedule(Schedule schedule) {
        this.schedule = schedule;
        return this;
    }

    public Action action() {
        return this.action;
    }

    public LogSearchRule withAction(Action action) {
        this.action = action;
        return this;
    }

    public void validate() {
        if (this.source() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property source in model LogSearchRule"));
        }
        this.source().validate();
        if (this.schedule() != null) {
            this.schedule().validate();
        }
        if (this.action() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property action in model LogSearchRule"));
        }
        this.action().validate();
    }
}

