/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.implementation;

import com.azure.resourcemanager.monitor.fluent.models.ScaleRuleInner;
import com.azure.resourcemanager.monitor.implementation.AutoscaleProfileImpl;
import com.azure.resourcemanager.monitor.models.ComparisonOperationType;
import com.azure.resourcemanager.monitor.models.MetricStatisticType;
import com.azure.resourcemanager.monitor.models.MetricTrigger;
import com.azure.resourcemanager.monitor.models.ScaleAction;
import com.azure.resourcemanager.monitor.models.ScaleDirection;
import com.azure.resourcemanager.monitor.models.ScaleRule;
import com.azure.resourcemanager.monitor.models.ScaleType;
import com.azure.resourcemanager.monitor.models.TimeAggregationType;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.WrapperImpl;
import java.time.Duration;

class ScaleRuleImpl
extends WrapperImpl<ScaleRuleInner>
implements ScaleRule,
ScaleRule.Definition,
ScaleRule.ParentUpdateDefinition,
ScaleRule.UpdateDefinition,
ScaleRule.Update {
    private final AutoscaleProfileImpl parent;

    ScaleRuleImpl(ScaleRuleInner innerObject, AutoscaleProfileImpl parent) {
        super((Object)innerObject);
        this.parent = parent;
        if (((ScaleRuleInner)this.innerModel()).metricTrigger() == null) {
            ((ScaleRuleInner)this.innerModel()).withMetricTrigger(new MetricTrigger());
        }
        if (((ScaleRuleInner)this.innerModel()).scaleAction() == null) {
            ((ScaleRuleInner)this.innerModel()).withScaleAction(new ScaleAction());
        }
    }

    @Override
    public String metricSource() {
        if (((ScaleRuleInner)this.innerModel()).metricTrigger() != null) {
            return ((ScaleRuleInner)this.innerModel()).metricTrigger().metricResourceUri();
        }
        return null;
    }

    @Override
    public String metricName() {
        if (((ScaleRuleInner)this.innerModel()).metricTrigger() != null) {
            return ((ScaleRuleInner)this.innerModel()).metricTrigger().metricName();
        }
        return null;
    }

    @Override
    public Duration duration() {
        if (((ScaleRuleInner)this.innerModel()).metricTrigger() != null) {
            return ((ScaleRuleInner)this.innerModel()).metricTrigger().timeWindow();
        }
        return null;
    }

    @Override
    public Duration frequency() {
        if (((ScaleRuleInner)this.innerModel()).metricTrigger() != null) {
            return ((ScaleRuleInner)this.innerModel()).metricTrigger().timeGrain();
        }
        return null;
    }

    @Override
    public MetricStatisticType frequencyStatistic() {
        if (((ScaleRuleInner)this.innerModel()).metricTrigger() != null) {
            return ((ScaleRuleInner)this.innerModel()).metricTrigger().statistic();
        }
        return null;
    }

    @Override
    public ComparisonOperationType condition() {
        if (((ScaleRuleInner)this.innerModel()).metricTrigger() != null) {
            return ((ScaleRuleInner)this.innerModel()).metricTrigger().operator();
        }
        return null;
    }

    @Override
    public TimeAggregationType timeAggregation() {
        if (((ScaleRuleInner)this.innerModel()).metricTrigger() != null) {
            return ((ScaleRuleInner)this.innerModel()).metricTrigger().timeAggregation();
        }
        return null;
    }

    @Override
    public double threshold() {
        if (((ScaleRuleInner)this.innerModel()).metricTrigger() != null) {
            return ((ScaleRuleInner)this.innerModel()).metricTrigger().threshold();
        }
        return 0.0;
    }

    @Override
    public ScaleDirection scaleDirection() {
        if (((ScaleRuleInner)this.innerModel()).scaleAction() != null) {
            return ((ScaleRuleInner)this.innerModel()).scaleAction().direction();
        }
        return null;
    }

    @Override
    public ScaleType scaleType() {
        if (((ScaleRuleInner)this.innerModel()).scaleAction() != null) {
            return ((ScaleRuleInner)this.innerModel()).scaleAction().type();
        }
        return null;
    }

    @Override
    public int scaleInstanceCount() {
        if (((ScaleRuleInner)this.innerModel()).scaleAction() != null) {
            return Integer.parseInt(((ScaleRuleInner)this.innerModel()).scaleAction().value());
        }
        return 0;
    }

    @Override
    public Duration cooldown() {
        if (((ScaleRuleInner)this.innerModel()).scaleAction() != null) {
            return ((ScaleRuleInner)this.innerModel()).scaleAction().cooldown();
        }
        return null;
    }

    public AutoscaleProfileImpl parent() {
        return this.parent;
    }

    @Override
    public AutoscaleProfileImpl attach() {
        return this.parent.addNewScaleRule(this);
    }

    @Override
    public ScaleRuleImpl withMetricSource(String metricSourceResourceId) {
        ((ScaleRuleInner)this.innerModel()).metricTrigger().withMetricResourceUri(metricSourceResourceId);
        return this;
    }

    @Override
    public ScaleRuleImpl withMetricName(String metricName) {
        ((ScaleRuleInner)this.innerModel()).metricTrigger().withMetricName(metricName);
        return this;
    }

    @Override
    public ScaleRuleImpl withStatistic(Duration duration, Duration frequency, MetricStatisticType statisticType) {
        ((ScaleRuleInner)this.innerModel()).metricTrigger().withStatistic(statisticType);
        ((ScaleRuleInner)this.innerModel()).metricTrigger().withTimeWindow(duration);
        ((ScaleRuleInner)this.innerModel()).metricTrigger().withTimeGrain(frequency);
        return this;
    }

    @Override
    public ScaleRuleImpl withStatistic() {
        return this.withStatistic(Duration.ofMinutes(10L), Duration.ofMinutes(1L), MetricStatisticType.AVERAGE);
    }

    @Override
    public ScaleRuleImpl withStatistic(Duration duration) {
        return this.withStatistic(duration, Duration.ofMinutes(1L), MetricStatisticType.AVERAGE);
    }

    @Override
    public ScaleRuleImpl withStatistic(Duration duration, MetricStatisticType statisticType) {
        return this.withStatistic(duration, Duration.ofMinutes(1L), statisticType);
    }

    @Override
    public ScaleRuleImpl withCondition(TimeAggregationType timeAggregation, ComparisonOperationType condition, double threshold) {
        ((ScaleRuleInner)this.innerModel()).metricTrigger().withOperator(condition);
        ((ScaleRuleInner)this.innerModel()).metricTrigger().withTimeAggregation(timeAggregation);
        ((ScaleRuleInner)this.innerModel()).metricTrigger().withThreshold(threshold);
        return this;
    }

    @Override
    public ScaleRuleImpl withScaleAction(ScaleDirection direction, ScaleType type, int instanceCountChange, Duration cooldown) {
        ((ScaleRuleInner)this.innerModel()).scaleAction().withDirection(direction);
        ((ScaleRuleInner)this.innerModel()).scaleAction().withType(type);
        ((ScaleRuleInner)this.innerModel()).scaleAction().withValue(Integer.toString(instanceCountChange));
        ((ScaleRuleInner)this.innerModel()).scaleAction().withCooldown(cooldown);
        return this;
    }
}

