// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** A condition of the scheduled query rule. */
@Fluent
public final class Condition {
    /*
     * Log query alert
     */
    @JsonProperty(value = "query")
    private String query;

    /*
     * Aggregation type. Relevant and required only for rules of the kind LogAlert.
     */
    @JsonProperty(value = "timeAggregation")
    private TimeAggregation timeAggregation;

    /*
     * The column containing the metric measure number. Relevant only for rules of the kind LogAlert.
     */
    @JsonProperty(value = "metricMeasureColumn")
    private String metricMeasureColumn;

    /*
     * The column containing the resource id. The content of the column must be a uri formatted as resource id.
     * Relevant only for rules of the kind LogAlert.
     */
    @JsonProperty(value = "resourceIdColumn")
    private String resourceIdColumn;

    /*
     * List of Dimensions conditions
     */
    @JsonProperty(value = "dimensions")
    private List<Dimension> dimensions;

    /*
     * The criteria operator. Relevant and required only for rules of the kind LogAlert.
     */
    @JsonProperty(value = "operator")
    private ConditionOperator operator;

    /*
     * the criteria threshold value that activates the alert. Relevant and required only for rules of the kind
     * LogAlert.
     */
    @JsonProperty(value = "threshold")
    private Double threshold;

    /*
     * The minimum number of violations required within the selected lookback time window required to raise an alert.
     * Relevant only for rules of the kind LogAlert.
     */
    @JsonProperty(value = "failingPeriods")
    private ConditionFailingPeriods failingPeriods;

    /*
     * The name of the metric to be sent. Relevant and required only for rules of the kind LogToMetric.
     */
    @JsonProperty(value = "metricName")
    private String metricName;

    /** Creates an instance of Condition class. */
    public Condition() {
    }

    /**
     * Get the query property: Log query alert.
     *
     * @return the query value.
     */
    public String query() {
        return this.query;
    }

    /**
     * Set the query property: Log query alert.
     *
     * @param query the query value to set.
     * @return the Condition object itself.
     */
    public Condition withQuery(String query) {
        this.query = query;
        return this;
    }

    /**
     * Get the timeAggregation property: Aggregation type. Relevant and required only for rules of the kind LogAlert.
     *
     * @return the timeAggregation value.
     */
    public TimeAggregation timeAggregation() {
        return this.timeAggregation;
    }

    /**
     * Set the timeAggregation property: Aggregation type. Relevant and required only for rules of the kind LogAlert.
     *
     * @param timeAggregation the timeAggregation value to set.
     * @return the Condition object itself.
     */
    public Condition withTimeAggregation(TimeAggregation timeAggregation) {
        this.timeAggregation = timeAggregation;
        return this;
    }

    /**
     * Get the metricMeasureColumn property: The column containing the metric measure number. Relevant only for rules of
     * the kind LogAlert.
     *
     * @return the metricMeasureColumn value.
     */
    public String metricMeasureColumn() {
        return this.metricMeasureColumn;
    }

    /**
     * Set the metricMeasureColumn property: The column containing the metric measure number. Relevant only for rules of
     * the kind LogAlert.
     *
     * @param metricMeasureColumn the metricMeasureColumn value to set.
     * @return the Condition object itself.
     */
    public Condition withMetricMeasureColumn(String metricMeasureColumn) {
        this.metricMeasureColumn = metricMeasureColumn;
        return this;
    }

    /**
     * Get the resourceIdColumn property: The column containing the resource id. The content of the column must be a uri
     * formatted as resource id. Relevant only for rules of the kind LogAlert.
     *
     * @return the resourceIdColumn value.
     */
    public String resourceIdColumn() {
        return this.resourceIdColumn;
    }

    /**
     * Set the resourceIdColumn property: The column containing the resource id. The content of the column must be a uri
     * formatted as resource id. Relevant only for rules of the kind LogAlert.
     *
     * @param resourceIdColumn the resourceIdColumn value to set.
     * @return the Condition object itself.
     */
    public Condition withResourceIdColumn(String resourceIdColumn) {
        this.resourceIdColumn = resourceIdColumn;
        return this;
    }

    /**
     * Get the dimensions property: List of Dimensions conditions.
     *
     * @return the dimensions value.
     */
    public List<Dimension> dimensions() {
        return this.dimensions;
    }

    /**
     * Set the dimensions property: List of Dimensions conditions.
     *
     * @param dimensions the dimensions value to set.
     * @return the Condition object itself.
     */
    public Condition withDimensions(List<Dimension> dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    /**
     * Get the operator property: The criteria operator. Relevant and required only for rules of the kind LogAlert.
     *
     * @return the operator value.
     */
    public ConditionOperator operator() {
        return this.operator;
    }

    /**
     * Set the operator property: The criteria operator. Relevant and required only for rules of the kind LogAlert.
     *
     * @param operator the operator value to set.
     * @return the Condition object itself.
     */
    public Condition withOperator(ConditionOperator operator) {
        this.operator = operator;
        return this;
    }

    /**
     * Get the threshold property: the criteria threshold value that activates the alert. Relevant and required only for
     * rules of the kind LogAlert.
     *
     * @return the threshold value.
     */
    public Double threshold() {
        return this.threshold;
    }

    /**
     * Set the threshold property: the criteria threshold value that activates the alert. Relevant and required only for
     * rules of the kind LogAlert.
     *
     * @param threshold the threshold value to set.
     * @return the Condition object itself.
     */
    public Condition withThreshold(Double threshold) {
        this.threshold = threshold;
        return this;
    }

    /**
     * Get the failingPeriods property: The minimum number of violations required within the selected lookback time
     * window required to raise an alert. Relevant only for rules of the kind LogAlert.
     *
     * @return the failingPeriods value.
     */
    public ConditionFailingPeriods failingPeriods() {
        return this.failingPeriods;
    }

    /**
     * Set the failingPeriods property: The minimum number of violations required within the selected lookback time
     * window required to raise an alert. Relevant only for rules of the kind LogAlert.
     *
     * @param failingPeriods the failingPeriods value to set.
     * @return the Condition object itself.
     */
    public Condition withFailingPeriods(ConditionFailingPeriods failingPeriods) {
        this.failingPeriods = failingPeriods;
        return this;
    }

    /**
     * Get the metricName property: The name of the metric to be sent. Relevant and required only for rules of the kind
     * LogToMetric.
     *
     * @return the metricName value.
     */
    public String metricName() {
        return this.metricName;
    }

    /**
     * Set the metricName property: The name of the metric to be sent. Relevant and required only for rules of the kind
     * LogToMetric.
     *
     * @param metricName the metricName value to set.
     * @return the Condition object itself.
     */
    public Condition withMetricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (dimensions() != null) {
            dimensions().forEach(e -> e.validate());
        }
        if (failingPeriods() != null) {
            failingPeriods().validate();
        }
    }
}
