// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** The data format of the log files. */
public final class KnownLogFilesDataSourceFormat extends ExpandableStringEnum<KnownLogFilesDataSourceFormat> {
    /** Static value text for KnownLogFilesDataSourceFormat. */
    public static final KnownLogFilesDataSourceFormat TEXT = fromString("text");

    /**
     * Creates or finds a KnownLogFilesDataSourceFormat from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding KnownLogFilesDataSourceFormat.
     */
    @JsonCreator
    public static KnownLogFilesDataSourceFormat fromString(String name) {
        return fromString(name, KnownLogFilesDataSourceFormat.class);
    }

    /**
     * Gets known KnownLogFilesDataSourceFormat values.
     *
     * @return known KnownLogFilesDataSourceFormat values.
     */
    public static Collection<KnownLogFilesDataSourceFormat> values() {
        return values(KnownLogFilesDataSourceFormat.class);
    }
}
