// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;

/** How the data that is collected should be combined over time. */
@Fluent
public final class ManagementEventAggregationCondition {
    /*
     * the condition operator.
     */
    @JsonProperty(value = "operator")
    private ConditionOperator operator;

    /*
     * The threshold value that activates the alert.
     */
    @JsonProperty(value = "threshold")
    private Double threshold;

    /*
     * the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold.
     * If specified then it must be between 5 minutes and 1 day.
     */
    @JsonProperty(value = "windowSize")
    private Duration windowSize;

    /** Creates an instance of ManagementEventAggregationCondition class. */
    public ManagementEventAggregationCondition() {
    }

    /**
     * Get the operator property: the condition operator.
     *
     * @return the operator value.
     */
    public ConditionOperator operator() {
        return this.operator;
    }

    /**
     * Set the operator property: the condition operator.
     *
     * @param operator the operator value to set.
     * @return the ManagementEventAggregationCondition object itself.
     */
    public ManagementEventAggregationCondition withOperator(ConditionOperator operator) {
        this.operator = operator;
        return this;
    }

    /**
     * Get the threshold property: The threshold value that activates the alert.
     *
     * @return the threshold value.
     */
    public Double threshold() {
        return this.threshold;
    }

    /**
     * Set the threshold property: The threshold value that activates the alert.
     *
     * @param threshold the threshold value to set.
     * @return the ManagementEventAggregationCondition object itself.
     */
    public ManagementEventAggregationCondition withThreshold(Double threshold) {
        this.threshold = threshold;
        return this;
    }

    /**
     * Get the windowSize property: the period of time (in ISO 8601 duration format) that is used to monitor alert
     * activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
     *
     * @return the windowSize value.
     */
    public Duration windowSize() {
        return this.windowSize;
    }

    /**
     * Set the windowSize property: the period of time (in ISO 8601 duration format) that is used to monitor alert
     * activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
     *
     * @param windowSize the windowSize value to set.
     * @return the ManagementEventAggregationCondition object itself.
     */
    public ManagementEventAggregationCondition withWindowSize(Duration windowSize) {
        this.windowSize = windowSize;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
