// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The rule criteria that defines the conditions of the scheduled query rule. */
@Fluent
public final class ScheduledQueryRuleCriteria {
    /*
     * A list of conditions to evaluate against the specified scopes
     */
    @JsonProperty(value = "allOf")
    private List<Condition> allOf;

    /** Creates an instance of ScheduledQueryRuleCriteria class. */
    public ScheduledQueryRuleCriteria() {
    }

    /**
     * Get the allOf property: A list of conditions to evaluate against the specified scopes.
     *
     * @return the allOf value.
     */
    public List<Condition> allOf() {
        return this.allOf;
    }

    /**
     * Set the allOf property: A list of conditions to evaluate against the specified scopes.
     *
     * @param allOf the allOf value to set.
     * @return the ScheduledQueryRuleCriteria object itself.
     */
    public ScheduledQueryRuleCriteria withAllOf(List<Condition> allOf) {
        this.allOf = allOf;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (allOf() != null) {
            allOf().forEach(e -> e.validate());
        }
    }
}
