/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.BaselineSensitivity;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class SingleBaseline {
    @JsonProperty(value="sensitivity", required=true)
    private BaselineSensitivity sensitivity;
    @JsonProperty(value="lowThresholds", required=true)
    private List<Double> lowThresholds;
    @JsonProperty(value="highThresholds", required=true)
    private List<Double> highThresholds;
    private static final ClientLogger LOGGER = new ClientLogger(SingleBaseline.class);

    public BaselineSensitivity sensitivity() {
        return this.sensitivity;
    }

    public SingleBaseline withSensitivity(BaselineSensitivity sensitivity) {
        this.sensitivity = sensitivity;
        return this;
    }

    public List<Double> lowThresholds() {
        return this.lowThresholds;
    }

    public SingleBaseline withLowThresholds(List<Double> lowThresholds) {
        this.lowThresholds = lowThresholds;
        return this;
    }

    public List<Double> highThresholds() {
        return this.highThresholds;
    }

    public SingleBaseline withHighThresholds(List<Double> highThresholds) {
        this.highThresholds = highThresholds;
        return this;
    }

    public void validate() {
        if (this.sensitivity() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property sensitivity in model SingleBaseline"));
        }
        if (this.lowThresholds() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property lowThresholds in model SingleBaseline"));
        }
        if (this.highThresholds() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property highThresholds in model SingleBaseline"));
        }
    }
}

