/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.BaselineMetadata;
import com.azure.resourcemanager.monitor.models.MetricSingleDimension;
import com.azure.resourcemanager.monitor.models.SingleBaseline;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class TimeSeriesBaseline {
    @JsonProperty(value="aggregation", required=true)
    private String aggregation;
    @JsonProperty(value="dimensions")
    private List<MetricSingleDimension> dimensions;
    @JsonProperty(value="timestamps", required=true)
    private List<OffsetDateTime> timestamps;
    @JsonProperty(value="data", required=true)
    private List<SingleBaseline> data;
    @JsonProperty(value="metadataValues")
    private List<BaselineMetadata> metadataValues;
    private static final ClientLogger LOGGER = new ClientLogger(TimeSeriesBaseline.class);

    public String aggregation() {
        return this.aggregation;
    }

    public TimeSeriesBaseline withAggregation(String aggregation) {
        this.aggregation = aggregation;
        return this;
    }

    public List<MetricSingleDimension> dimensions() {
        return this.dimensions;
    }

    public TimeSeriesBaseline withDimensions(List<MetricSingleDimension> dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public List<OffsetDateTime> timestamps() {
        return this.timestamps;
    }

    public TimeSeriesBaseline withTimestamps(List<OffsetDateTime> timestamps) {
        this.timestamps = timestamps;
        return this;
    }

    public List<SingleBaseline> data() {
        return this.data;
    }

    public TimeSeriesBaseline withData(List<SingleBaseline> data) {
        this.data = data;
        return this;
    }

    public List<BaselineMetadata> metadataValues() {
        return this.metadataValues;
    }

    public TimeSeriesBaseline withMetadataValues(List<BaselineMetadata> metadataValues) {
        this.metadataValues = metadataValues;
        return this;
    }

    public void validate() {
        if (this.aggregation() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property aggregation in model TimeSeriesBaseline"));
        }
        if (this.dimensions() != null) {
            this.dimensions().forEach(e -> e.validate());
        }
        if (this.timestamps() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property timestamps in model TimeSeriesBaseline"));
        }
        if (this.data() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property data in model TimeSeriesBaseline"));
        }
        this.data().forEach(e -> e.validate());
        if (this.metadataValues() != null) {
            this.metadataValues().forEach(e -> e.validate());
        }
    }
}

