// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Definition of the network rules. */
@Fluent
public class NetworkRuleSet {
    /*
     * The configuration to set whether network access from public internet to the endpoints are allowed.
     */
    @JsonProperty(value = "publicNetworkAccess")
    private KnownPublicNetworkAccessOptions publicNetworkAccess;

    /** Creates an instance of NetworkRuleSet class. */
    public NetworkRuleSet() {
    }

    /**
     * Get the publicNetworkAccess property: The configuration to set whether network access from public internet to the
     * endpoints are allowed.
     *
     * @return the publicNetworkAccess value.
     */
    public KnownPublicNetworkAccessOptions publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    /**
     * Set the publicNetworkAccess property: The configuration to set whether network access from public internet to the
     * endpoints are allowed.
     *
     * @param publicNetworkAccess the publicNetworkAccess value to set.
     * @return the NetworkRuleSet object itself.
     */
    public NetworkRuleSet withPublicNetworkAccess(KnownPublicNetworkAccessOptions publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
