// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.monitor.fluent.models.ScheduledQueryRuleResourceInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Represents a collection of scheduled query rule resources. */
@Fluent
public final class ScheduledQueryRuleResourceCollection {
    /*
     * The values for the scheduled query rule resources.
     */
    @JsonProperty(value = "value")
    private List<ScheduledQueryRuleResourceInner> value;

    /*
     * Provides the link to retrieve the next set of elements.
     */
    @JsonProperty(value = "nextLink", access = JsonProperty.Access.WRITE_ONLY)
    private String nextLink;

    /** Creates an instance of ScheduledQueryRuleResourceCollection class. */
    public ScheduledQueryRuleResourceCollection() {
    }

    /**
     * Get the value property: The values for the scheduled query rule resources.
     *
     * @return the value value.
     */
    public List<ScheduledQueryRuleResourceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The values for the scheduled query rule resources.
     *
     * @param value the value value to set.
     * @return the ScheduledQueryRuleResourceCollection object itself.
     */
    public ScheduledQueryRuleResourceCollection withValue(List<ScheduledQueryRuleResourceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Provides the link to retrieve the next set of elements.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
