// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.monitor.fluent.models.ActivityLogAlertResourceInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * A list of Activity Log Alert rules.
 */
@Fluent
public final class AlertRuleList {
    /*
     * The list of Activity Log Alert rules.
     */
    @JsonProperty(value = "value")
    private List<ActivityLogAlertResourceInner> value;

    /*
     * Provides the link to retrieve the next set of elements.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Creates an instance of AlertRuleList class.
     */
    public AlertRuleList() {
    }

    /**
     * Get the value property: The list of Activity Log Alert rules.
     * 
     * @return the value value.
     */
    public List<ActivityLogAlertResourceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of Activity Log Alert rules.
     * 
     * @param value the value value to set.
     * @return the AlertRuleList object itself.
     */
    public AlertRuleList withValue(List<ActivityLogAlertResourceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Provides the link to retrieve the next set of elements.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Provides the link to retrieve the next set of elements.
     * 
     * @param nextLink the nextLink value to set.
     * @return the AlertRuleList object itself.
     */
    public AlertRuleList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
