// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The minimum number of violations required within the selected lookback time window required to raise an alert.
 * Relevant only for rules of the kind LogAlert.
 */
@Fluent
public final class ConditionFailingPeriods {
    /*
     * The number of aggregated lookback points. The lookback time window is calculated based on the aggregation
     * granularity (windowSize) and the selected number of aggregated points. Default value is 1
     */
    @JsonProperty(value = "numberOfEvaluationPeriods")
    private Long numberOfEvaluationPeriods;

    /*
     * The number of violations to trigger an alert. Should be smaller or equal to numberOfEvaluationPeriods. Default
     * value is 1
     */
    @JsonProperty(value = "minFailingPeriodsToAlert")
    private Long minFailingPeriodsToAlert;

    /**
     * Creates an instance of ConditionFailingPeriods class.
     */
    public ConditionFailingPeriods() {
    }

    /**
     * Get the numberOfEvaluationPeriods property: The number of aggregated lookback points. The lookback time window
     * is calculated based on the aggregation granularity (windowSize) and the selected number of aggregated points.
     * Default value is 1.
     * 
     * @return the numberOfEvaluationPeriods value.
     */
    public Long numberOfEvaluationPeriods() {
        return this.numberOfEvaluationPeriods;
    }

    /**
     * Set the numberOfEvaluationPeriods property: The number of aggregated lookback points. The lookback time window
     * is calculated based on the aggregation granularity (windowSize) and the selected number of aggregated points.
     * Default value is 1.
     * 
     * @param numberOfEvaluationPeriods the numberOfEvaluationPeriods value to set.
     * @return the ConditionFailingPeriods object itself.
     */
    public ConditionFailingPeriods withNumberOfEvaluationPeriods(Long numberOfEvaluationPeriods) {
        this.numberOfEvaluationPeriods = numberOfEvaluationPeriods;
        return this;
    }

    /**
     * Get the minFailingPeriodsToAlert property: The number of violations to trigger an alert. Should be smaller or
     * equal to numberOfEvaluationPeriods. Default value is 1.
     * 
     * @return the minFailingPeriodsToAlert value.
     */
    public Long minFailingPeriodsToAlert() {
        return this.minFailingPeriodsToAlert;
    }

    /**
     * Set the minFailingPeriodsToAlert property: The number of violations to trigger an alert. Should be smaller or
     * equal to numberOfEvaluationPeriods. Default value is 1.
     * 
     * @param minFailingPeriodsToAlert the minFailingPeriodsToAlert value to set.
     * @return the ConditionFailingPeriods object itself.
     */
    public ConditionFailingPeriods withMinFailingPeriodsToAlert(Long minFailingPeriodsToAlert) {
        this.minFailingPeriodsToAlert = minFailingPeriodsToAlert;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
