// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Describes a receiver that should be resubscribed.
 */
@Fluent
public final class EnableRequest {
    /*
     * The name of the receiver to resubscribe.
     */
    @JsonProperty(value = "receiverName", required = true)
    private String receiverName;

    /**
     * Creates an instance of EnableRequest class.
     */
    public EnableRequest() {
    }

    /**
     * Get the receiverName property: The name of the receiver to resubscribe.
     * 
     * @return the receiverName value.
     */
    public String receiverName() {
        return this.receiverName;
    }

    /**
     * Set the receiverName property: The name of the receiver to resubscribe.
     * 
     * @param receiverName the receiverName value to set.
     * @return the EnableRequest object itself.
     */
    public EnableRequest withReceiverName(String receiverName) {
        this.receiverName = receiverName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (receiverName() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property receiverName in model EnableRequest"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(EnableRequest.class);
}
