/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.monitor.models.AccessModeSettings;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class AzureMonitorPrivateLinkScopeProperties {
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="privateEndpointConnections", access=JsonProperty.Access.WRITE_ONLY)
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    @JsonProperty(value="accessModeSettings", required=true)
    private AccessModeSettings accessModeSettings;
    private static final ClientLogger LOGGER = new ClientLogger(AzureMonitorPrivateLinkScopeProperties.class);

    public String provisioningState() {
        return this.provisioningState;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public AccessModeSettings accessModeSettings() {
        return this.accessModeSettings;
    }

    public AzureMonitorPrivateLinkScopeProperties withAccessModeSettings(AccessModeSettings accessModeSettings) {
        this.accessModeSettings = accessModeSettings;
        return this;
    }

    public void validate() {
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.accessModeSettings() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property accessModeSettings in model AzureMonitorPrivateLinkScopeProperties"));
        }
        this.accessModeSettings().validate();
    }
}

