/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.TimeSeriesBaseline;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.util.List;

public final class MetricBaselinesProperties {
    @JsonProperty(value="timespan", required=true)
    private String timespan;
    @JsonProperty(value="interval", required=true)
    private Duration interval;
    @JsonProperty(value="namespace")
    private String namespace;
    @JsonProperty(value="baselines", required=true)
    private List<TimeSeriesBaseline> baselines;
    private static final ClientLogger LOGGER = new ClientLogger(MetricBaselinesProperties.class);

    public String timespan() {
        return this.timespan;
    }

    public MetricBaselinesProperties withTimespan(String timespan) {
        this.timespan = timespan;
        return this;
    }

    public Duration interval() {
        return this.interval;
    }

    public MetricBaselinesProperties withInterval(Duration interval) {
        this.interval = interval;
        return this;
    }

    public String namespace() {
        return this.namespace;
    }

    public MetricBaselinesProperties withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public List<TimeSeriesBaseline> baselines() {
        return this.baselines;
    }

    public MetricBaselinesProperties withBaselines(List<TimeSeriesBaseline> baselines) {
        this.baselines = baselines;
        return this;
    }

    public void validate() {
        if (this.timespan() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property timespan in model MetricBaselinesProperties"));
        }
        if (this.interval() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property interval in model MetricBaselinesProperties"));
        }
        if (this.baselines() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property baselines in model MetricBaselinesProperties"));
        }
        this.baselines().forEach(e -> e.validate());
    }
}

