/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

public final class MetricValue {
    @JsonProperty(value="timeStamp", required=true)
    private OffsetDateTime timestamp;
    @JsonProperty(value="average")
    private Double average;
    @JsonProperty(value="minimum")
    private Double minimum;
    @JsonProperty(value="maximum")
    private Double maximum;
    @JsonProperty(value="total")
    private Double total;
    @JsonProperty(value="count")
    private Double count;
    private static final ClientLogger LOGGER = new ClientLogger(MetricValue.class);

    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    public MetricValue withTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public Double average() {
        return this.average;
    }

    public MetricValue withAverage(Double average) {
        this.average = average;
        return this;
    }

    public Double minimum() {
        return this.minimum;
    }

    public MetricValue withMinimum(Double minimum) {
        this.minimum = minimum;
        return this;
    }

    public Double maximum() {
        return this.maximum;
    }

    public MetricValue withMaximum(Double maximum) {
        this.maximum = maximum;
        return this;
    }

    public Double total() {
        return this.total;
    }

    public MetricValue withTotal(Double total) {
        this.total = total;
        return this;
    }

    public Double count() {
        return this.count;
    }

    public MetricValue withCount(Double count) {
        this.count = count;
        return this;
    }

    public void validate() {
        if (this.timestamp() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property timestamp in model MetricValue"));
        }
    }
}

