/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.monitor.fluent.ActionGroupsClient;
import com.azure.resourcemanager.monitor.fluent.models.ActionGroupResourceInner;
import com.azure.resourcemanager.monitor.implementation.MonitorClientImpl;
import com.azure.resourcemanager.monitor.models.ActionGroupList;
import com.azure.resourcemanager.monitor.models.ActionGroupPatchBody;
import com.azure.resourcemanager.monitor.models.EnableRequest;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import reactor.core.publisher.Mono;

public final class ActionGroupsClientImpl
implements InnerSupportsGet<ActionGroupResourceInner>,
InnerSupportsListing<ActionGroupResourceInner>,
InnerSupportsDelete<Void>,
ActionGroupsClient {
    private final ClientLogger logger = new ClientLogger(ActionGroupsClientImpl.class);
    private final ActionGroupsService service;
    private final MonitorClientImpl client;

    ActionGroupsClientImpl(MonitorClientImpl client) {
        this.service = (ActionGroupsService)RestProxy.create(ActionGroupsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<ActionGroupResourceInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String actionGroupName, ActionGroupResourceInner actionGroup) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (actionGroup == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionGroup is required and cannot be null."));
        }
        actionGroup.validate();
        String apiVersion = "2019-06-01";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, actionGroupName, this.client.getSubscriptionId(), "2019-06-01", actionGroup, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ActionGroupResourceInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String actionGroupName, ActionGroupResourceInner actionGroup, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (actionGroup == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionGroup is required and cannot be null."));
        }
        actionGroup.validate();
        String apiVersion = "2019-06-01";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, actionGroupName, this.client.getSubscriptionId(), "2019-06-01", actionGroup, context);
    }

    @Override
    public Mono<ActionGroupResourceInner> createOrUpdateAsync(String resourceGroupName, String actionGroupName, ActionGroupResourceInner actionGroup) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, actionGroupName, actionGroup).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ActionGroupResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public ActionGroupResourceInner createOrUpdate(String resourceGroupName, String actionGroupName, ActionGroupResourceInner actionGroup) {
        return (ActionGroupResourceInner)((Object)this.createOrUpdateAsync(resourceGroupName, actionGroupName, actionGroup).block());
    }

    @Override
    public Response<ActionGroupResourceInner> createOrUpdateWithResponse(String resourceGroupName, String actionGroupName, ActionGroupResourceInner actionGroup, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, actionGroupName, actionGroup, context).block();
    }

    @Override
    public Mono<Response<ActionGroupResourceInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String actionGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-06-01";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, actionGroupName, this.client.getSubscriptionId(), "2019-06-01", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ActionGroupResourceInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String actionGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-06-01";
        context = this.client.mergeContext(context);
        return this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, actionGroupName, this.client.getSubscriptionId(), "2019-06-01", context);
    }

    @Override
    public Mono<ActionGroupResourceInner> getByResourceGroupAsync(String resourceGroupName, String actionGroupName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, actionGroupName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ActionGroupResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public ActionGroupResourceInner getByResourceGroup(String resourceGroupName, String actionGroupName) {
        return (ActionGroupResourceInner)((Object)this.getByResourceGroupAsync(resourceGroupName, actionGroupName).block());
    }

    @Override
    public Response<ActionGroupResourceInner> getByResourceGroupWithResponse(String resourceGroupName, String actionGroupName, Context context) {
        return (Response)this.getByResourceGroupWithResponseAsync(resourceGroupName, actionGroupName, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String actionGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-06-01";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, actionGroupName, this.client.getSubscriptionId(), "2019-06-01", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String actionGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-06-01";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, actionGroupName, this.client.getSubscriptionId(), "2019-06-01", context);
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String actionGroupName) {
        return this.deleteWithResponseAsync(resourceGroupName, actionGroupName).flatMap(res -> Mono.empty());
    }

    @Override
    public void delete(String resourceGroupName, String actionGroupName) {
        this.deleteAsync(resourceGroupName, actionGroupName).block();
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String actionGroupName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, actionGroupName, context).block();
    }

    @Override
    public Mono<Response<ActionGroupResourceInner>> updateWithResponseAsync(String resourceGroupName, String actionGroupName, ActionGroupPatchBody actionGroupPatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (actionGroupPatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionGroupPatch is required and cannot be null."));
        }
        actionGroupPatch.validate();
        String apiVersion = "2019-06-01";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, actionGroupName, "2019-06-01", actionGroupPatch, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ActionGroupResourceInner>> updateWithResponseAsync(String resourceGroupName, String actionGroupName, ActionGroupPatchBody actionGroupPatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (actionGroupPatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionGroupPatch is required and cannot be null."));
        }
        actionGroupPatch.validate();
        String apiVersion = "2019-06-01";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, actionGroupName, "2019-06-01", actionGroupPatch, context);
    }

    @Override
    public Mono<ActionGroupResourceInner> updateAsync(String resourceGroupName, String actionGroupName, ActionGroupPatchBody actionGroupPatch) {
        return this.updateWithResponseAsync(resourceGroupName, actionGroupName, actionGroupPatch).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ActionGroupResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public ActionGroupResourceInner update(String resourceGroupName, String actionGroupName, ActionGroupPatchBody actionGroupPatch) {
        return (ActionGroupResourceInner)((Object)this.updateAsync(resourceGroupName, actionGroupName, actionGroupPatch).block());
    }

    @Override
    public Response<ActionGroupResourceInner> updateWithResponse(String resourceGroupName, String actionGroupName, ActionGroupPatchBody actionGroupPatch, Context context) {
        return (Response)this.updateWithResponseAsync(resourceGroupName, actionGroupName, actionGroupPatch, context).block();
    }

    private Mono<PagedResponse<ActionGroupResourceInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-06-01";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), "2019-06-01", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ActionGroupList)res.getValue()).value(), null, null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<ActionGroupResourceInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-06-01";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), "2019-06-01", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ActionGroupList)res.getValue()).value(), null, null));
    }

    @Override
    public PagedFlux<ActionGroupResourceInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync());
    }

    private PagedFlux<ActionGroupResourceInner> listAsync(Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(context));
    }

    @Override
    public PagedIterable<ActionGroupResourceInner> list() {
        return new PagedIterable(this.listAsync());
    }

    @Override
    public PagedIterable<ActionGroupResourceInner> list(Context context) {
        return new PagedIterable(this.listAsync(context));
    }

    private Mono<PagedResponse<ActionGroupResourceInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-06-01";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, this.client.getSubscriptionId(), "2019-06-01", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ActionGroupList)res.getValue()).value(), null, null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<ActionGroupResourceInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-06-01";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, this.client.getSubscriptionId(), "2019-06-01", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ActionGroupList)res.getValue()).value(), null, null));
    }

    @Override
    public PagedFlux<ActionGroupResourceInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName));
    }

    private PagedFlux<ActionGroupResourceInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, context));
    }

    @Override
    public PagedIterable<ActionGroupResourceInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    public PagedIterable<ActionGroupResourceInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, context));
    }

    @Override
    public Mono<Response<Void>> enableReceiverWithResponseAsync(String resourceGroupName, String actionGroupName, String receiverName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (receiverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter receiverName is required and cannot be null."));
        }
        String apiVersion = "2019-06-01";
        EnableRequest enableRequest = new EnableRequest();
        enableRequest.withReceiverName(receiverName);
        return FluxUtil.withContext(context -> this.service.enableReceiver(this.client.getEndpoint(), resourceGroupName, actionGroupName, this.client.getSubscriptionId(), "2019-06-01", enableRequest, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> enableReceiverWithResponseAsync(String resourceGroupName, String actionGroupName, String receiverName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (receiverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter receiverName is required and cannot be null."));
        }
        String apiVersion = "2019-06-01";
        EnableRequest enableRequest = new EnableRequest();
        enableRequest.withReceiverName(receiverName);
        context = this.client.mergeContext(context);
        return this.service.enableReceiver(this.client.getEndpoint(), resourceGroupName, actionGroupName, this.client.getSubscriptionId(), "2019-06-01", enableRequest, context);
    }

    @Override
    public Mono<Void> enableReceiverAsync(String resourceGroupName, String actionGroupName, String receiverName) {
        return this.enableReceiverWithResponseAsync(resourceGroupName, actionGroupName, receiverName).flatMap(res -> Mono.empty());
    }

    @Override
    public void enableReceiver(String resourceGroupName, String actionGroupName, String receiverName) {
        this.enableReceiverAsync(resourceGroupName, actionGroupName, receiverName).block();
    }

    @Override
    public Response<Void> enableReceiverWithResponse(String resourceGroupName, String actionGroupName, String receiverName, Context context) {
        return (Response)this.enableReceiverWithResponseAsync(resourceGroupName, actionGroupName, receiverName, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MonitorClientActionG")
    private static interface ActionGroupsService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/actionGroups/{actionGroupName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ActionGroupResourceInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="actionGroupName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") ActionGroupResourceInner var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/actionGroups/{actionGroupName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ActionGroupResourceInner>> getByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="actionGroupName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, Context var6);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/actionGroups/{actionGroupName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="actionGroupName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/actionGroups/{actionGroupName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ActionGroupResourceInner>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="actionGroupName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") ActionGroupPatchBody var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/microsoft.insights/actionGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ActionGroupList>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, Context var4);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/actionGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ActionGroupList>> listByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="api-version") String var4, Context var5);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/actionGroups/{actionGroupName}/subscribe")
        @ExpectedResponses(value={200, 409})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> enableReceiver(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="actionGroupName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") EnableRequest var6, Context var7);
    }
}

