/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.monitor.fluent.AlertRuleIncidentsClient;
import com.azure.resourcemanager.monitor.fluent.models.IncidentInner;
import com.azure.resourcemanager.monitor.implementation.MonitorClientImpl;
import com.azure.resourcemanager.monitor.models.IncidentListResult;
import reactor.core.publisher.Mono;

public final class AlertRuleIncidentsClientImpl
implements AlertRuleIncidentsClient {
    private final ClientLogger logger = new ClientLogger(AlertRuleIncidentsClientImpl.class);
    private final AlertRuleIncidentsService service;
    private final MonitorClientImpl client;

    AlertRuleIncidentsClientImpl(MonitorClientImpl client) {
        this.service = (AlertRuleIncidentsService)RestProxy.create(AlertRuleIncidentsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<IncidentInner>> getWithResponseAsync(String resourceGroupName, String ruleName, String incidentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ruleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleName is required and cannot be null."));
        }
        if (incidentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter incidentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2016-03-01";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, ruleName, incidentName, "2016-03-01", this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<IncidentInner>> getWithResponseAsync(String resourceGroupName, String ruleName, String incidentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ruleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleName is required and cannot be null."));
        }
        if (incidentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter incidentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2016-03-01";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, ruleName, incidentName, "2016-03-01", this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<IncidentInner> getAsync(String resourceGroupName, String ruleName, String incidentName) {
        return this.getWithResponseAsync(resourceGroupName, ruleName, incidentName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((IncidentInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public IncidentInner get(String resourceGroupName, String ruleName, String incidentName) {
        return (IncidentInner)this.getAsync(resourceGroupName, ruleName, incidentName).block();
    }

    @Override
    public Response<IncidentInner> getWithResponse(String resourceGroupName, String ruleName, String incidentName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, ruleName, incidentName, context).block();
    }

    private Mono<PagedResponse<IncidentInner>> listByAlertRuleSinglePageAsync(String resourceGroupName, String ruleName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ruleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2016-03-01";
        return FluxUtil.withContext(context -> this.service.listByAlertRule(this.client.getEndpoint(), resourceGroupName, ruleName, "2016-03-01", this.client.getSubscriptionId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IncidentListResult)res.getValue()).value(), null, null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<IncidentInner>> listByAlertRuleSinglePageAsync(String resourceGroupName, String ruleName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ruleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2016-03-01";
        context = this.client.mergeContext(context);
        return this.service.listByAlertRule(this.client.getEndpoint(), resourceGroupName, ruleName, "2016-03-01", this.client.getSubscriptionId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IncidentListResult)res.getValue()).value(), null, null));
    }

    @Override
    public PagedFlux<IncidentInner> listByAlertRuleAsync(String resourceGroupName, String ruleName) {
        return new PagedFlux(() -> this.listByAlertRuleSinglePageAsync(resourceGroupName, ruleName));
    }

    private PagedFlux<IncidentInner> listByAlertRuleAsync(String resourceGroupName, String ruleName, Context context) {
        return new PagedFlux(() -> this.listByAlertRuleSinglePageAsync(resourceGroupName, ruleName, context));
    }

    @Override
    public PagedIterable<IncidentInner> listByAlertRule(String resourceGroupName, String ruleName) {
        return new PagedIterable(this.listByAlertRuleAsync(resourceGroupName, ruleName));
    }

    @Override
    public PagedIterable<IncidentInner> listByAlertRule(String resourceGroupName, String ruleName, Context context) {
        return new PagedIterable(this.listByAlertRuleAsync(resourceGroupName, ruleName, context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MonitorClientAlertRu")
    private static interface AlertRuleIncidentsService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/alertrules/{ruleName}/incidents/{incidentName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<IncidentInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="ruleName") String var3, @PathParam(value="incidentName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/alertrules/{ruleName}/incidents")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<IncidentListResult>> listByAlertRule(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="ruleName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, Context var6);
    }
}

