/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.monitor.fluent.MetricBaselinesClient;
import com.azure.resourcemanager.monitor.fluent.models.BaselineResponseInner;
import com.azure.resourcemanager.monitor.fluent.models.CalculateBaselineResponseInner;
import com.azure.resourcemanager.monitor.implementation.MonitorClientImpl;
import com.azure.resourcemanager.monitor.models.ResultType;
import com.azure.resourcemanager.monitor.models.TimeSeriesInformation;
import java.time.Duration;
import reactor.core.publisher.Mono;

public final class MetricBaselinesClientImpl
implements MetricBaselinesClient {
    private final ClientLogger logger = new ClientLogger(MetricBaselinesClientImpl.class);
    private final MetricBaselinesService service;
    private final MonitorClientImpl client;

    MetricBaselinesClientImpl(MonitorClientImpl client) {
        this.service = (MetricBaselinesService)RestProxy.create(MetricBaselinesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<BaselineResponseInner>> getWithResponseAsync(String resourceUri, String metricName, String timespan, Duration interval, String aggregation, String sensitivities, ResultType resultType) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        if (metricName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter metricName is required and cannot be null."));
        }
        String apiVersion = "2017-11-01-preview";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceUri, metricName, timespan, interval, aggregation, sensitivities, resultType, "2017-11-01-preview", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<BaselineResponseInner>> getWithResponseAsync(String resourceUri, String metricName, String timespan, Duration interval, String aggregation, String sensitivities, ResultType resultType, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        if (metricName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter metricName is required and cannot be null."));
        }
        String apiVersion = "2017-11-01-preview";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceUri, metricName, timespan, interval, aggregation, sensitivities, resultType, "2017-11-01-preview", context);
    }

    @Override
    public Mono<BaselineResponseInner> getAsync(String resourceUri, String metricName, String timespan, Duration interval, String aggregation, String sensitivities, ResultType resultType) {
        return this.getWithResponseAsync(resourceUri, metricName, timespan, interval, aggregation, sensitivities, resultType).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((BaselineResponseInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<BaselineResponseInner> getAsync(String resourceUri, String metricName) {
        String timespan = null;
        Duration interval = null;
        String aggregation = null;
        String sensitivities = null;
        ResultType resultType = null;
        return this.getWithResponseAsync(resourceUri, metricName, timespan, interval, aggregation, sensitivities, resultType).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((BaselineResponseInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public BaselineResponseInner get(String resourceUri, String metricName) {
        String timespan = null;
        Duration interval = null;
        String aggregation = null;
        String sensitivities = null;
        ResultType resultType = null;
        return (BaselineResponseInner)this.getAsync(resourceUri, metricName, timespan, interval, aggregation, sensitivities, resultType).block();
    }

    @Override
    public Response<BaselineResponseInner> getWithResponse(String resourceUri, String metricName, String timespan, Duration interval, String aggregation, String sensitivities, ResultType resultType, Context context) {
        return (Response)this.getWithResponseAsync(resourceUri, metricName, timespan, interval, aggregation, sensitivities, resultType, context).block();
    }

    @Override
    public Mono<Response<CalculateBaselineResponseInner>> calculateBaselineWithResponseAsync(String resourceUri, TimeSeriesInformation timeSeriesInformation) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        if (timeSeriesInformation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter timeSeriesInformation is required and cannot be null."));
        }
        timeSeriesInformation.validate();
        String apiVersion = "2017-11-01-preview";
        return FluxUtil.withContext(context -> this.service.calculateBaseline(this.client.getEndpoint(), resourceUri, "2017-11-01-preview", timeSeriesInformation, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<CalculateBaselineResponseInner>> calculateBaselineWithResponseAsync(String resourceUri, TimeSeriesInformation timeSeriesInformation, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        if (timeSeriesInformation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter timeSeriesInformation is required and cannot be null."));
        }
        timeSeriesInformation.validate();
        String apiVersion = "2017-11-01-preview";
        context = this.client.mergeContext(context);
        return this.service.calculateBaseline(this.client.getEndpoint(), resourceUri, "2017-11-01-preview", timeSeriesInformation, context);
    }

    @Override
    public Mono<CalculateBaselineResponseInner> calculateBaselineAsync(String resourceUri, TimeSeriesInformation timeSeriesInformation) {
        return this.calculateBaselineWithResponseAsync(resourceUri, timeSeriesInformation).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CalculateBaselineResponseInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public CalculateBaselineResponseInner calculateBaseline(String resourceUri, TimeSeriesInformation timeSeriesInformation) {
        return (CalculateBaselineResponseInner)this.calculateBaselineAsync(resourceUri, timeSeriesInformation).block();
    }

    @Override
    public Response<CalculateBaselineResponseInner> calculateBaselineWithResponse(String resourceUri, TimeSeriesInformation timeSeriesInformation, Context context) {
        return (Response)this.calculateBaselineWithResponseAsync(resourceUri, timeSeriesInformation, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MonitorClientMetricB")
    private static interface MetricBaselinesService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/{resourceUri}/providers/microsoft.insights/baseline/{metricName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BaselineResponseInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceUri", encoded=true) String var2, @PathParam(value="metricName") String var3, @QueryParam(value="timespan") String var4, @QueryParam(value="interval") Duration var5, @QueryParam(value="aggregation") String var6, @QueryParam(value="sensitivities") String var7, @QueryParam(value="resultType") ResultType var8, @QueryParam(value="api-version") String var9, Context var10);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Post(value="/{resourceUri}/providers/microsoft.insights/calculatebaseline")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CalculateBaselineResponseInner>> calculateBaseline(@HostParam(value="$host") String var1, @PathParam(value="resourceUri", encoded=true) String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") TimeSeriesInformation var4, Context var5);
    }
}

