/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.MetricAlertAction;
import com.azure.resourcemanager.monitor.models.MetricAlertCriteria;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class MetricAlertResourcePatch {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(MetricAlertResourcePatch.class);
    @JsonProperty(value="tags")
    private Map<String, String> tags;
    @JsonProperty(value="properties.description")
    private String description;
    @JsonProperty(value="properties.severity")
    private Integer severity;
    @JsonProperty(value="properties.enabled")
    private Boolean enabled;
    @JsonProperty(value="properties.scopes")
    private List<String> scopes;
    @JsonProperty(value="properties.evaluationFrequency")
    private Duration evaluationFrequency;
    @JsonProperty(value="properties.windowSize")
    private Duration windowSize;
    @JsonProperty(value="properties.targetResourceType")
    private String targetResourceType;
    @JsonProperty(value="properties.targetResourceRegion")
    private String targetResourceRegion;
    @JsonProperty(value="properties.criteria")
    private MetricAlertCriteria criteria;
    @JsonProperty(value="properties.autoMitigate")
    private Boolean autoMitigate;
    @JsonProperty(value="properties.actions")
    private List<MetricAlertAction> actions;
    @JsonProperty(value="properties.lastUpdatedTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastUpdatedTime;

    public Map<String, String> tags() {
        return this.tags;
    }

    public MetricAlertResourcePatch withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String description() {
        return this.description;
    }

    public MetricAlertResourcePatch withDescription(String description) {
        this.description = description;
        return this;
    }

    public Integer severity() {
        return this.severity;
    }

    public MetricAlertResourcePatch withSeverity(Integer severity) {
        this.severity = severity;
        return this;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public MetricAlertResourcePatch withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public List<String> scopes() {
        return this.scopes;
    }

    public MetricAlertResourcePatch withScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public Duration evaluationFrequency() {
        return this.evaluationFrequency;
    }

    public MetricAlertResourcePatch withEvaluationFrequency(Duration evaluationFrequency) {
        this.evaluationFrequency = evaluationFrequency;
        return this;
    }

    public Duration windowSize() {
        return this.windowSize;
    }

    public MetricAlertResourcePatch withWindowSize(Duration windowSize) {
        this.windowSize = windowSize;
        return this;
    }

    public String targetResourceType() {
        return this.targetResourceType;
    }

    public MetricAlertResourcePatch withTargetResourceType(String targetResourceType) {
        this.targetResourceType = targetResourceType;
        return this;
    }

    public String targetResourceRegion() {
        return this.targetResourceRegion;
    }

    public MetricAlertResourcePatch withTargetResourceRegion(String targetResourceRegion) {
        this.targetResourceRegion = targetResourceRegion;
        return this;
    }

    public MetricAlertCriteria criteria() {
        return this.criteria;
    }

    public MetricAlertResourcePatch withCriteria(MetricAlertCriteria criteria) {
        this.criteria = criteria;
        return this;
    }

    public Boolean autoMitigate() {
        return this.autoMitigate;
    }

    public MetricAlertResourcePatch withAutoMitigate(Boolean autoMitigate) {
        this.autoMitigate = autoMitigate;
        return this;
    }

    public List<MetricAlertAction> actions() {
        return this.actions;
    }

    public MetricAlertResourcePatch withActions(List<MetricAlertAction> actions) {
        this.actions = actions;
        return this;
    }

    public OffsetDateTime lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public void validate() {
        if (this.criteria() != null) {
            this.criteria().validate();
        }
        if (this.actions() != null) {
            this.actions().forEach(e -> e.validate());
        }
    }
}

