// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.TimeSeriesBaseline;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.util.List;

/**
 * The baseline results of a single metric.
 */
@Fluent
public final class SingleMetricBaselineInner {
    /*
     * The metric baseline Id.
     */
    @JsonProperty(value = "id", required = true)
    private String id;

    /*
     * The resource type of the metric baseline resource.
     */
    @JsonProperty(value = "type", required = true)
    private String type;

    /*
     * The name of the metric for which the baselines were retrieved.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /*
     * The metric baseline properties of the metric.
     */
    @JsonProperty(value = "properties", required = true)
    private MetricBaselinesProperties innerProperties = new MetricBaselinesProperties();

    /**
     * Creates an instance of SingleMetricBaselineInner class.
     */
    public SingleMetricBaselineInner() {
    }

    /**
     * Get the id property: The metric baseline Id.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The metric baseline Id.
     * 
     * @param id the id value to set.
     * @return the SingleMetricBaselineInner object itself.
     */
    public SingleMetricBaselineInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the type property: The resource type of the metric baseline resource.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: The resource type of the metric baseline resource.
     * 
     * @param type the type value to set.
     * @return the SingleMetricBaselineInner object itself.
     */
    public SingleMetricBaselineInner withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the name property: The name of the metric for which the baselines were retrieved.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the metric for which the baselines were retrieved.
     * 
     * @param name the name value to set.
     * @return the SingleMetricBaselineInner object itself.
     */
    public SingleMetricBaselineInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the innerProperties property: The metric baseline properties of the metric.
     * 
     * @return the innerProperties value.
     */
    private MetricBaselinesProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the timespan property: The timespan for which the data was retrieved. Its value consists of two datetimes
     * concatenated, separated by '/'. This may be adjusted in the future and returned back from what was originally
     * requested.
     * 
     * @return the timespan value.
     */
    public String timespan() {
        return this.innerProperties() == null ? null : this.innerProperties().timespan();
    }

    /**
     * Set the timespan property: The timespan for which the data was retrieved. Its value consists of two datetimes
     * concatenated, separated by '/'. This may be adjusted in the future and returned back from what was originally
     * requested.
     * 
     * @param timespan the timespan value to set.
     * @return the SingleMetricBaselineInner object itself.
     */
    public SingleMetricBaselineInner withTimespan(String timespan) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricBaselinesProperties();
        }
        this.innerProperties().withTimespan(timespan);
        return this;
    }

    /**
     * Get the interval property: The interval (window size) for which the metric data was returned in. This may be
     * adjusted in the future and returned back from what was originally requested. This is not present if a metadata
     * request was made.
     * 
     * @return the interval value.
     */
    public Duration interval() {
        return this.innerProperties() == null ? null : this.innerProperties().interval();
    }

    /**
     * Set the interval property: The interval (window size) for which the metric data was returned in. This may be
     * adjusted in the future and returned back from what was originally requested. This is not present if a metadata
     * request was made.
     * 
     * @param interval the interval value to set.
     * @return the SingleMetricBaselineInner object itself.
     */
    public SingleMetricBaselineInner withInterval(Duration interval) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricBaselinesProperties();
        }
        this.innerProperties().withInterval(interval);
        return this;
    }

    /**
     * Get the namespace property: The namespace of the metrics been queried.
     * 
     * @return the namespace value.
     */
    public String namespace() {
        return this.innerProperties() == null ? null : this.innerProperties().namespace();
    }

    /**
     * Set the namespace property: The namespace of the metrics been queried.
     * 
     * @param namespace the namespace value to set.
     * @return the SingleMetricBaselineInner object itself.
     */
    public SingleMetricBaselineInner withNamespace(String namespace) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricBaselinesProperties();
        }
        this.innerProperties().withNamespace(namespace);
        return this;
    }

    /**
     * Get the baselines property: The baseline for each time series that was queried.
     * 
     * @return the baselines value.
     */
    public List<TimeSeriesBaseline> baselines() {
        return this.innerProperties() == null ? null : this.innerProperties().baselines();
    }

    /**
     * Set the baselines property: The baseline for each time series that was queried.
     * 
     * @param baselines the baselines value to set.
     * @return the SingleMetricBaselineInner object itself.
     */
    public SingleMetricBaselineInner withBaselines(List<TimeSeriesBaseline> baselines) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricBaselinesProperties();
        }
        this.innerProperties().withBaselines(baselines);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (id() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property id in model SingleMetricBaselineInner"));
        }
        if (type() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property type in model SingleMetricBaselineInner"));
        }
        if (name() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property name in model SingleMetricBaselineInner"));
        }
        if (innerProperties() == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                "Missing required property innerProperties in model SingleMetricBaselineInner"));
        } else {
            innerProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SingleMetricBaselineInner.class);
}
