// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The Http request info.
 */
@Fluent
public final class HttpRequestInfo implements JsonSerializable<HttpRequestInfo> {
    /*
     * the client request id.
     */
    private String clientRequestId;

    /*
     * the client Ip Address
     */
    private String clientIpAddress;

    /*
     * the Http request method.
     */
    private String method;

    /*
     * the Uri.
     */
    private String uri;

    /**
     * Creates an instance of HttpRequestInfo class.
     */
    public HttpRequestInfo() {
    }

    /**
     * Get the clientRequestId property: the client request id.
     * 
     * @return the clientRequestId value.
     */
    public String clientRequestId() {
        return this.clientRequestId;
    }

    /**
     * Set the clientRequestId property: the client request id.
     * 
     * @param clientRequestId the clientRequestId value to set.
     * @return the HttpRequestInfo object itself.
     */
    public HttpRequestInfo withClientRequestId(String clientRequestId) {
        this.clientRequestId = clientRequestId;
        return this;
    }

    /**
     * Get the clientIpAddress property: the client Ip Address.
     * 
     * @return the clientIpAddress value.
     */
    public String clientIpAddress() {
        return this.clientIpAddress;
    }

    /**
     * Set the clientIpAddress property: the client Ip Address.
     * 
     * @param clientIpAddress the clientIpAddress value to set.
     * @return the HttpRequestInfo object itself.
     */
    public HttpRequestInfo withClientIpAddress(String clientIpAddress) {
        this.clientIpAddress = clientIpAddress;
        return this;
    }

    /**
     * Get the method property: the Http request method.
     * 
     * @return the method value.
     */
    public String method() {
        return this.method;
    }

    /**
     * Set the method property: the Http request method.
     * 
     * @param method the method value to set.
     * @return the HttpRequestInfo object itself.
     */
    public HttpRequestInfo withMethod(String method) {
        this.method = method;
        return this;
    }

    /**
     * Get the uri property: the Uri.
     * 
     * @return the uri value.
     */
    public String uri() {
        return this.uri;
    }

    /**
     * Set the uri property: the Uri.
     * 
     * @param uri the uri value to set.
     * @return the HttpRequestInfo object itself.
     */
    public HttpRequestInfo withUri(String uri) {
        this.uri = uri;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("clientRequestId", this.clientRequestId);
        jsonWriter.writeStringField("clientIpAddress", this.clientIpAddress);
        jsonWriter.writeStringField("method", this.method);
        jsonWriter.writeStringField("uri", this.uri);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HttpRequestInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HttpRequestInfo if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the HttpRequestInfo.
     */
    public static HttpRequestInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HttpRequestInfo deserializedHttpRequestInfo = new HttpRequestInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("clientRequestId".equals(fieldName)) {
                    deserializedHttpRequestInfo.clientRequestId = reader.getString();
                } else if ("clientIpAddress".equals(fieldName)) {
                    deserializedHttpRequestInfo.clientIpAddress = reader.getString();
                } else if ("method".equals(fieldName)) {
                    deserializedHttpRequestInfo.method = reader.getString();
                } else if ("uri".equals(fieldName)) {
                    deserializedHttpRequestInfo.uri = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHttpRequestInfo;
        });
    }
}
