// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.Recurrence;
import com.azure.resourcemanager.monitor.models.ScaleCapacity;
import com.azure.resourcemanager.monitor.models.TimeWindow;
import java.io.IOException;
import java.util.List;

/**
 * Autoscale profile.
 */
@Fluent
public final class AutoscaleProfileInner implements JsonSerializable<AutoscaleProfileInner> {
    /*
     * the name of the profile.
     */
    private String name;

    /*
     * the number of instances that can be used during this profile.
     */
    private ScaleCapacity capacity;

    /*
     * the collection of rules that provide the triggers and parameters for the scaling action. A maximum of 10 rules
     * can be specified.
     */
    private List<ScaleRuleInner> rules;

    /*
     * the specific date-time for the profile. This element is not used if the Recurrence element is used.
     */
    private TimeWindow fixedDate;

    /*
     * the repeating times at which this profile begins. This element is not used if the FixedDate element is used.
     */
    private Recurrence recurrence;

    /**
     * Creates an instance of AutoscaleProfileInner class.
     */
    public AutoscaleProfileInner() {
    }

    /**
     * Get the name property: the name of the profile.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: the name of the profile.
     * 
     * @param name the name value to set.
     * @return the AutoscaleProfileInner object itself.
     */
    public AutoscaleProfileInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the capacity property: the number of instances that can be used during this profile.
     * 
     * @return the capacity value.
     */
    public ScaleCapacity capacity() {
        return this.capacity;
    }

    /**
     * Set the capacity property: the number of instances that can be used during this profile.
     * 
     * @param capacity the capacity value to set.
     * @return the AutoscaleProfileInner object itself.
     */
    public AutoscaleProfileInner withCapacity(ScaleCapacity capacity) {
        this.capacity = capacity;
        return this;
    }

    /**
     * Get the rules property: the collection of rules that provide the triggers and parameters for the scaling action.
     * A maximum of 10 rules can be specified.
     * 
     * @return the rules value.
     */
    public List<ScaleRuleInner> rules() {
        return this.rules;
    }

    /**
     * Set the rules property: the collection of rules that provide the triggers and parameters for the scaling action.
     * A maximum of 10 rules can be specified.
     * 
     * @param rules the rules value to set.
     * @return the AutoscaleProfileInner object itself.
     */
    public AutoscaleProfileInner withRules(List<ScaleRuleInner> rules) {
        this.rules = rules;
        return this;
    }

    /**
     * Get the fixedDate property: the specific date-time for the profile. This element is not used if the Recurrence
     * element is used.
     * 
     * @return the fixedDate value.
     */
    public TimeWindow fixedDate() {
        return this.fixedDate;
    }

    /**
     * Set the fixedDate property: the specific date-time for the profile. This element is not used if the Recurrence
     * element is used.
     * 
     * @param fixedDate the fixedDate value to set.
     * @return the AutoscaleProfileInner object itself.
     */
    public AutoscaleProfileInner withFixedDate(TimeWindow fixedDate) {
        this.fixedDate = fixedDate;
        return this;
    }

    /**
     * Get the recurrence property: the repeating times at which this profile begins. This element is not used if the
     * FixedDate element is used.
     * 
     * @return the recurrence value.
     */
    public Recurrence recurrence() {
        return this.recurrence;
    }

    /**
     * Set the recurrence property: the repeating times at which this profile begins. This element is not used if the
     * FixedDate element is used.
     * 
     * @param recurrence the recurrence value to set.
     * @return the AutoscaleProfileInner object itself.
     */
    public AutoscaleProfileInner withRecurrence(Recurrence recurrence) {
        this.recurrence = recurrence;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model AutoscaleProfileInner"));
        }
        if (capacity() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property capacity in model AutoscaleProfileInner"));
        } else {
            capacity().validate();
        }
        if (rules() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property rules in model AutoscaleProfileInner"));
        } else {
            rules().forEach(e -> e.validate());
        }
        if (fixedDate() != null) {
            fixedDate().validate();
        }
        if (recurrence() != null) {
            recurrence().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AutoscaleProfileInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("capacity", this.capacity);
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("fixedDate", this.fixedDate);
        jsonWriter.writeJsonField("recurrence", this.recurrence);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AutoscaleProfileInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AutoscaleProfileInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AutoscaleProfileInner.
     */
    public static AutoscaleProfileInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AutoscaleProfileInner deserializedAutoscaleProfileInner = new AutoscaleProfileInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedAutoscaleProfileInner.name = reader.getString();
                } else if ("capacity".equals(fieldName)) {
                    deserializedAutoscaleProfileInner.capacity = ScaleCapacity.fromJson(reader);
                } else if ("rules".equals(fieldName)) {
                    List<ScaleRuleInner> rules = reader.readArray(reader1 -> ScaleRuleInner.fromJson(reader1));
                    deserializedAutoscaleProfileInner.rules = rules;
                } else if ("fixedDate".equals(fieldName)) {
                    deserializedAutoscaleProfileInner.fixedDate = TimeWindow.fromJson(reader);
                } else if ("recurrence".equals(fieldName)) {
                    deserializedAutoscaleProfileInner.recurrence = Recurrence.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAutoscaleProfileInner;
        });
    }
}
