// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The number of instances that can be used during this profile.
 */
@Fluent
public final class ScaleCapacity implements JsonSerializable<ScaleCapacity> {
    /*
     * the minimum number of instances for the resource.
     */
    private String minimum;

    /*
     * the maximum number of instances for the resource. The actual maximum number of instances is limited by the cores
     * that are available in the subscription.
     */
    private String maximum;

    /*
     * the number of instances that will be set if metrics are not available for evaluation. The default is only used if
     * the current instance count is lower than the default.
     */
    private String defaultProperty;

    /**
     * Creates an instance of ScaleCapacity class.
     */
    public ScaleCapacity() {
    }

    /**
     * Get the minimum property: the minimum number of instances for the resource.
     * 
     * @return the minimum value.
     */
    public String minimum() {
        return this.minimum;
    }

    /**
     * Set the minimum property: the minimum number of instances for the resource.
     * 
     * @param minimum the minimum value to set.
     * @return the ScaleCapacity object itself.
     */
    public ScaleCapacity withMinimum(String minimum) {
        this.minimum = minimum;
        return this;
    }

    /**
     * Get the maximum property: the maximum number of instances for the resource. The actual maximum number of
     * instances is limited by the cores that are available in the subscription.
     * 
     * @return the maximum value.
     */
    public String maximum() {
        return this.maximum;
    }

    /**
     * Set the maximum property: the maximum number of instances for the resource. The actual maximum number of
     * instances is limited by the cores that are available in the subscription.
     * 
     * @param maximum the maximum value to set.
     * @return the ScaleCapacity object itself.
     */
    public ScaleCapacity withMaximum(String maximum) {
        this.maximum = maximum;
        return this;
    }

    /**
     * Get the defaultProperty property: the number of instances that will be set if metrics are not available for
     * evaluation. The default is only used if the current instance count is lower than the default.
     * 
     * @return the defaultProperty value.
     */
    public String defaultProperty() {
        return this.defaultProperty;
    }

    /**
     * Set the defaultProperty property: the number of instances that will be set if metrics are not available for
     * evaluation. The default is only used if the current instance count is lower than the default.
     * 
     * @param defaultProperty the defaultProperty value to set.
     * @return the ScaleCapacity object itself.
     */
    public ScaleCapacity withDefaultProperty(String defaultProperty) {
        this.defaultProperty = defaultProperty;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (minimum() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property minimum in model ScaleCapacity"));
        }
        if (maximum() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property maximum in model ScaleCapacity"));
        }
        if (defaultProperty() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property defaultProperty in model ScaleCapacity"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ScaleCapacity.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("minimum", this.minimum);
        jsonWriter.writeStringField("maximum", this.maximum);
        jsonWriter.writeStringField("default", this.defaultProperty);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ScaleCapacity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ScaleCapacity if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ScaleCapacity.
     */
    public static ScaleCapacity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ScaleCapacity deserializedScaleCapacity = new ScaleCapacity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("minimum".equals(fieldName)) {
                    deserializedScaleCapacity.minimum = reader.getString();
                } else if ("maximum".equals(fieldName)) {
                    deserializedScaleCapacity.maximum = reader.getString();
                } else if ("default".equals(fieldName)) {
                    deserializedScaleCapacity.defaultProperty = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedScaleCapacity;
        });
    }
}
