// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Actions to invoke when the alert fires.
 */
@Fluent
public final class Actions implements JsonSerializable<Actions> {
    /*
     * Action Group resource Ids to invoke when the alert fires.
     */
    private List<String> actionGroups;

    /*
     * The properties of an alert payload.
     */
    private Map<String, String> customProperties;

    /**
     * Creates an instance of Actions class.
     */
    public Actions() {
    }

    /**
     * Get the actionGroups property: Action Group resource Ids to invoke when the alert fires.
     * 
     * @return the actionGroups value.
     */
    public List<String> actionGroups() {
        return this.actionGroups;
    }

    /**
     * Set the actionGroups property: Action Group resource Ids to invoke when the alert fires.
     * 
     * @param actionGroups the actionGroups value to set.
     * @return the Actions object itself.
     */
    public Actions withActionGroups(List<String> actionGroups) {
        this.actionGroups = actionGroups;
        return this;
    }

    /**
     * Get the customProperties property: The properties of an alert payload.
     * 
     * @return the customProperties value.
     */
    public Map<String, String> customProperties() {
        return this.customProperties;
    }

    /**
     * Set the customProperties property: The properties of an alert payload.
     * 
     * @param customProperties the customProperties value to set.
     * @return the Actions object itself.
     */
    public Actions withCustomProperties(Map<String, String> customProperties) {
        this.customProperties = customProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("actionGroups", this.actionGroups, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("customProperties", this.customProperties,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Actions from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Actions if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IOException If an error occurs while reading the Actions.
     */
    public static Actions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Actions deserializedActions = new Actions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("actionGroups".equals(fieldName)) {
                    List<String> actionGroups = reader.readArray(reader1 -> reader1.getString());
                    deserializedActions.actionGroups = actionGroups;
                } else if ("customProperties".equals(fieldName)) {
                    Map<String, String> customProperties = reader.readMap(reader1 -> reader1.getString());
                    deserializedActions.customProperties = customProperties;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedActions;
        });
    }
}
