// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes a receiver that should be resubscribed.
 */
@Fluent
public final class EnableRequest implements JsonSerializable<EnableRequest> {
    /*
     * The name of the receiver to resubscribe.
     */
    private String receiverName;

    /**
     * Creates an instance of EnableRequest class.
     */
    public EnableRequest() {
    }

    /**
     * Get the receiverName property: The name of the receiver to resubscribe.
     * 
     * @return the receiverName value.
     */
    public String receiverName() {
        return this.receiverName;
    }

    /**
     * Set the receiverName property: The name of the receiver to resubscribe.
     * 
     * @param receiverName the receiverName value to set.
     * @return the EnableRequest object itself.
     */
    public EnableRequest withReceiverName(String receiverName) {
        this.receiverName = receiverName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (receiverName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property receiverName in model EnableRequest"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(EnableRequest.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("receiverName", this.receiverName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EnableRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EnableRequest if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the EnableRequest.
     */
    public static EnableRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EnableRequest deserializedEnableRequest = new EnableRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("receiverName".equals(fieldName)) {
                    deserializedEnableRequest.receiverName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEnableRequest;
        });
    }
}
